/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.services.common.provider;

import java.util.ArrayList;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.provider.RuntimeContextObjectProvider;
import org.eclipse.gyrex.services.common.IService;
import org.eclipse.gyrex.services.common.internal.ServiceStatusMonitor;
import org.eclipse.gyrex.services.common.provider.BaseService;
import org.eclipse.gyrex.services.common.status.IStatusMonitor;

public abstract class ServiceProvider
extends RuntimeContextObjectProvider {
    private final Class[] providedServices;

    protected ServiceProvider(Class<? extends IService> providedService, Class ... providedServices) throws IllegalArgumentException {
        if (providedService == null) {
            throw new IllegalArgumentException("providedService must not be null");
        }
        if (!IService.class.isAssignableFrom(providedService)) {
            throw new IllegalArgumentException("service '" + providedService.getName() + "' is not assignable to '" + IService.class.getName() + "'");
        }
        ArrayList<Class> services = new ArrayList<Class>(providedServices.length);
        services.add(providedService);
        if (providedServices != null) {
            Class[] classArray = providedServices;
            int n = providedServices.length;
            int n2 = 0;
            while (n2 < n) {
                Class service = classArray[n2];
                if (service == null) {
                    throw new IllegalArgumentException("providedServices list contains NULL entries which is not supported");
                }
                if (!IService.class.isAssignableFrom(service)) {
                    throw new IllegalArgumentException("service '" + service.getName() + "' is not assignable to '" + IService.class.getName() + "'");
                }
                services.add(service);
                ++n2;
            }
        }
        this.providedServices = services.toArray(new Class[services.size()]);
    }

    public abstract BaseService createServiceInstance(Class var1, IRuntimeContext var2, IStatusMonitor var3);

    public final Object getObject(Class type, IRuntimeContext context) {
        return this.createServiceInstance(type, context, new ServiceStatusMonitor());
    }

    public final Class[] getObjectTypes() {
        return this.providedServices;
    }

    public final void ungetObject(Object object, IRuntimeContext context) {
        if (object instanceof BaseService) {
            ((BaseService)object).close();
        }
    }
}

