/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class TypeParametersFix
extends CompilationUnitRewriteOperationsFix {
    public static TypeParametersFix createInsertInferredTypeArgumentsFix(CompilationUnit compilationUnit, ParameterizedType node) {
        if (node == null) {
            return null;
        }
        ArrayList changedNodes = new ArrayList();
        node.accept((ASTVisitor)new InsertTypeArgumentsVisitor(changedNodes));
        if (changedNodes.isEmpty()) {
            return null;
        }
        InsertTypeArgumentsOperation op = new InsertTypeArgumentsOperation(new ParameterizedType[]{node});
        return new TypeParametersFix(FixMessages.TypeParametersFix_insert_inferred_type_arguments_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static TypeParametersFix createRemoveRedundantTypeArgumentsFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        if (id == 16778100) {
            ParameterizedType parameterizedType = TypeParametersFix.getParameterizedType(compilationUnit, problem);
            if (parameterizedType == null) {
                return null;
            }
            RemoveTypeArgumentsOperation operation = new RemoveTypeArgumentsOperation(parameterizedType);
            return new TypeParametersFix(FixMessages.TypeParametersFix_remove_redundant_type_arguments_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation});
        }
        return null;
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean insertInferredTypeArguments, boolean removeRedundantTypeArguments) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return TypeParametersFix.createCleanUp(compilationUnit, locations, insertInferredTypeArguments, removeRedundantTypeArguments);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean insertInferredTypeArguments, boolean removeRedundantTypeArguments) {
        if (insertInferredTypeArguments) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept((ASTVisitor)new InsertTypeArgumentsVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            InsertTypeArgumentsOperation op = new InsertTypeArgumentsOperation(changedNodes.toArray(new ParameterizedType[changedNodes.size()]));
            return new TypeParametersFix(FixMessages.TypeParametersFix_insert_inferred_type_arguments_name, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        if (removeRedundantTypeArguments) {
            ArrayList<RemoveTypeArgumentsOperation> result = new ArrayList<RemoveTypeArgumentsOperation>();
            int i = 0;
            while (i < problems.length) {
                IProblemLocation problem = problems[i];
                int id = problem.getProblemId();
                if (id == 16778100) {
                    ParameterizedType parameterizedType = TypeParametersFix.getParameterizedType(compilationUnit, problem);
                    if (parameterizedType == null) {
                        return null;
                    }
                    result.add(new RemoveTypeArgumentsOperation(parameterizedType));
                }
                ++i;
            }
            if (!result.isEmpty()) {
                return new TypeParametersFix(FixMessages.TypeParametersFix_remove_redundant_type_arguments_name, compilationUnit, result.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[result.size()]));
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static ParameterizedType getParameterizedType(CompilationUnit compilationUnit, IProblemLocation problem) {
        selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            selectedNode = selectedNode.getParent();
lbl5:
            // 2 sources

            ** while (!(selectedNode instanceof ParameterizedType) && !(selectedNode instanceof Statement))
        }
lbl6:
        // 1 sources

        if (selectedNode instanceof ParameterizedType) {
            return (ParameterizedType)selectedNode;
        }
        return null;
    }

    protected TypeParametersFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class InsertTypeArgumentsOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final ParameterizedType[] fCreatedTypes;

        public InsertTypeArgumentsOperation(ParameterizedType[] parameterizedTypes) {
            this.fCreatedTypes = parameterizedTypes;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.TypeParametersFix_insert_inferred_type_arguments_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            int i = 0;
            while (i < this.fCreatedTypes.length) {
                ParameterizedType createdType = this.fCreatedTypes[i];
                ITypeBinding[] typeArguments = createdType.resolveBinding().getTypeArguments();
                ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(cuRewrite.getRoot(), createdType.getStartPosition(), importRewrite);
                ListRewrite argumentsRewrite = rewrite.getListRewrite((ASTNode)createdType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
                int j = 0;
                while (j < typeArguments.length) {
                    ITypeBinding typeArgument = typeArguments[j];
                    Type argumentNode = importRewrite.addImport(typeArgument, ast, (ImportRewrite.ImportRewriteContext)importContext);
                    argumentsRewrite.insertLast((ASTNode)argumentNode, group);
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InsertTypeArgumentsVisitor
    extends ASTVisitor {
        private final ArrayList<ASTNode> fNodes;

        private InsertTypeArgumentsVisitor(ArrayList<ASTNode> nodes) {
            this.fNodes = nodes;
        }

        public boolean visit(ParameterizedType createdType) {
            if (createdType == null || createdType.typeArguments().size() != 0) {
                return true;
            }
            ITypeBinding binding = createdType.resolveBinding();
            if (binding == null) {
                return true;
            }
            ITypeBinding[] typeArguments = binding.getTypeArguments();
            if (typeArguments.length == 0) {
                return true;
            }
            this.fNodes.add((ASTNode)createdType);
            return true;
        }
    }

    private static class RemoveTypeArgumentsOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final ParameterizedType fParameterizedType;

        public RemoveTypeArgumentsOperation(ParameterizedType parameterizedType) {
            this.fParameterizedType = parameterizedType;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.TypeParametersFix_remove_redundant_type_arguments_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.fParameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            List typeArguments = this.fParameterizedType.typeArguments();
            Iterator iterator = typeArguments.iterator();
            while (iterator.hasNext()) {
                listRewrite.remove((ASTNode)iterator.next(), group);
            }
        }
    }
}

