/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UnpackJarAntExporter
extends FatJarAntExporter {
    public UnpackJarAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
        super(antScriptLocation, jarLocation, launchConfiguration);
    }

    protected void buildANTScript(IPath antScriptLocation, String projectName, IPath absJarfile, String mainClass, FatJarAntExporter.SourceInfo[] sourceInfos) throws IOException {
        FileOutputStream outputStream = null;
        try {
            FatJarAntExporter.SourceInfo sourceInfo;
            FatJarAntExporter.SourceInfo sourceInfo2;
            outputStream = new FileOutputStream(antScriptLocation.toFile());
            String absJarname = absJarfile.toString();
            String subfolder = String.valueOf(absJarfile.removeFileExtension().lastSegment()) + "_lib";
            String absSubfolder = absJarfile.removeLastSegments(1).append(subfolder).toString();
            DocumentBuilder docBuilder = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                docBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotGetXmlBuilder);
            }
            Document document = docBuilder.newDocument();
            Element project = document.createElement("project");
            project.setAttribute("name", "Create Runnable Jar for Project " + projectName + " with libraries in sub-folder");
            project.setAttribute("default", "create_run_jar");
            Comment comment = document.createComment("this file was created by Eclipse Runnable JAR Export Wizard");
            project.appendChild(comment);
            comment = document.createComment("ANT 1.7 is required                                        ");
            project.appendChild(comment);
            document.appendChild(project);
            Element target = document.createElement("target");
            target.setAttribute("name", "create_run_jar");
            project.appendChild(target);
            Element jar = document.createElement("jar");
            jar.setAttribute("destfile", absJarname);
            target.appendChild(jar);
            Element manifest = document.createElement("manifest");
            jar.appendChild(manifest);
            Element attribute = document.createElement("attribute");
            attribute.setAttribute("name", "Main-Class");
            attribute.setAttribute("value", mainClass);
            manifest.appendChild(attribute);
            attribute = document.createElement("attribute");
            attribute.setAttribute("name", "Class-Path");
            StringBuffer classPath = new StringBuffer();
            classPath.append(".");
            int i = 0;
            while (i < sourceInfos.length) {
                sourceInfo2 = sourceInfos[i];
                if (sourceInfo2.isJar) {
                    classPath.append(" ").append(subfolder).append("/").append(new File(sourceInfo2.absPath).getName());
                }
                ++i;
            }
            attribute.setAttribute("value", classPath.toString());
            manifest.appendChild(attribute);
            i = 0;
            while (i < sourceInfos.length) {
                sourceInfo2 = sourceInfos[i];
                if (!sourceInfo2.isJar) {
                    Element fileset = document.createElement("fileset");
                    fileset.setAttribute("dir", sourceInfo2.absPath);
                    jar.appendChild(fileset);
                }
                ++i;
            }
            Element delete = document.createElement("delete");
            delete.setAttribute("dir", absSubfolder);
            target.appendChild(delete);
            Element mkdir = document.createElement("mkdir");
            mkdir.setAttribute("dir", absSubfolder);
            target.appendChild(mkdir);
            int i2 = 0;
            while (i2 < sourceInfos.length) {
                sourceInfo = sourceInfos[i2];
                if (sourceInfo.isJar) {
                    Element copy = document.createElement("copy");
                    copy.setAttribute("file", sourceInfo.absPath);
                    copy.setAttribute("todir", absSubfolder);
                    target.appendChild(copy);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < sourceInfos.length) {
                sourceInfo = sourceInfos[i2];
                boolean cfr_ignored_0 = sourceInfo.isJar;
                ++i2;
            }
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outputStream);
                transformer.transform(source, result);
            }
            catch (TransformerException transformerException) {
                throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotTransformToXML);
            }
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }
}

