/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeTools {
    public static final String SERIALIZABLE_NAME = Serializable.class.getName();
    public static final Predicate<IType> IS_CLASS = new IsClass();
    public static final Predicate<IType> IS_INTERFACE = new IsInterface();
    public static final Predicate<IType> IS_ENUM = new IsEnum();
    public static final IType[] EMPTY_ARRAY = new IType[0];
    public static final Transformer<IType, String> NAME_TRANSFORMER = new NameTransformer();

    public static boolean isSubType(String potentialSubTypeName, String potentialSuperTypeName, IJavaProject javaProject) {
        try {
            return TypeTools.isSubType_(javaProject.findType(potentialSubTypeName), javaProject.findType(potentialSuperTypeName));
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isSubType(IType potentialSubType, String potentialSuperTypeName) {
        try {
            return TypeTools.isSubType_(potentialSubType, potentialSuperTypeName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private static boolean isSubType_(IType potentialSubType, String potentialSuperTypeName) throws JavaModelException {
        return TypeTools.isSubType_(potentialSubType, potentialSubType.getJavaProject().findType(potentialSuperTypeName));
    }

    private static boolean isSubType_(IType potentialSubType, IType potentialSuperType) throws JavaModelException {
        if (potentialSubType == null || potentialSuperType == null) {
            return false;
        }
        if (potentialSubType.equals(potentialSuperType)) {
            return true;
        }
        IJavaProject javaProject = potentialSubType.getJavaProject();
        if (javaProject.findType(Object.class.getName()).equals(potentialSuperType)) {
            return true;
        }
        String potentialSuperTypeName = potentialSuperType.getFullyQualifiedName();
        for (String superTypeName : TypeTools.getResolvedSuperTypeNames(potentialSubType)) {
            if (superTypeName.equals(potentialSuperTypeName)) {
                return true;
            }
            if (!TypeTools.isSubType_(javaProject.findType(superTypeName), potentialSuperType)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<String> getResolvedSuperTypeNames(IType type) throws JavaModelException {
        Iterable<String> nonResolvedSuperTypeNames = TypeTools.getNonResolvedSuperTypeNames(type);
        if (type.isBinary()) {
            return nonResolvedSuperTypeNames;
        }
        ArrayList<String> resolvedSuperTypeNames = new ArrayList<String>();
        for (String superTypeName : nonResolvedSuperTypeNames) {
            resolvedSuperTypeNames.add(TypeTools.resolveType_(type, superTypeName));
        }
        return resolvedSuperTypeNames;
    }

    private static Iterable<String> getNonResolvedSuperTypeNames(IType type) throws JavaModelException {
        return IterableTools.concatenate((Iterable[])new Iterable[]{IterableTools.removeNulls((Iterable)IterableTools.singletonIterable((Object)type.getSuperclassName())), IterableTools.iterable((Object[])type.getSuperInterfaceNames())});
    }

    private static String resolveType_(IType type, String typeName) throws JavaModelException {
        String[][] resolvedClassNames = type.resolveType(typeName);
        if (resolvedClassNames == null) {
            return null;
        }
        String pkg = resolvedClassNames[0][0];
        String cls = resolvedClassNames[0][1];
        return pkg.length() == 0 ? cls : String.valueOf(pkg) + '.' + cls;
    }

    public static String resolveType(IType type, String typeName) {
        try {
            return TypeTools.resolveType_(type, typeName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    public static boolean isSerializable(IType type) {
        return TypeTools.isSubType(type, SERIALIZABLE_NAME);
    }

    public static boolean isSerializable(String typeName, IJavaProject javaProject) {
        return TypeTools.isSubType(typeName, SERIALIZABLE_NAME, javaProject);
    }

    public static boolean hasPublicZeroArgConstructor(String typeName, IJavaProject javaProject) {
        IType type;
        if (javaProject != null && typeName != null && (type = JavaProjectTools.findType(javaProject, typeName)) != null) {
            return TypeTools.hasPublicZeroArgConstructor(type);
        }
        return false;
    }

    public static boolean hasPublicZeroArgConstructor(IType type) {
        try {
            return TypeTools.hasPublicZeroArgConstructor_(type);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private static boolean hasPublicZeroArgConstructor_(IType type) throws JavaModelException {
        boolean ctorDefined = false;
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.isConstructor()) {
                if (method.getNumberOfParameters() == 0 && Flags.isPublic((int)method.getFlags())) {
                    return true;
                }
                ctorDefined = true;
            }
            ++n2;
        }
        return !ctorDefined;
    }

    public static boolean isClass(IType type) {
        try {
            return type.isClass();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isInterface(IType type) {
        try {
            return type.isInterface();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isEnum(IType type) {
        try {
            return type.isEnum();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static IType[] getTypes(IType type) {
        try {
            return type.getTypes();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return EMPTY_ARRAY;
        }
    }

    private TypeTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsClass
    extends PredicateAdapter<IType> {
        public boolean evaluate(IType type) {
            return TypeTools.isClass(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsEnum
    extends PredicateAdapter<IType> {
        public boolean evaluate(IType type) {
            return TypeTools.isEnum(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsInterface
    extends PredicateAdapter<IType> {
        public boolean evaluate(IType type) {
            return TypeTools.isInterface(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameTransformer
    extends TransformerAdapter<IType, String> {
        public String transform(IType type) {
            return type.getFullyQualifiedName();
        }
    }
}

