/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedType;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaManagedType<P extends JpaContextModel>
extends AbstractJavaContextModel<P>
implements JavaManagedType {
    protected final JavaResourceType resourceType;
    protected String name;

    protected AbstractJavaManagedType(P parent, JavaResourceType resourceType) {
        super(parent);
        this.resourceType = resourceType;
        this.name = this.resourceType.getTypeBinding().getQualifiedName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName(this.resourceType.getTypeBinding().getQualifiedName());
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return ClassNameTools.simpleName((String)this.name);
    }

    @Override
    public String getTypeQualifiedName() {
        String packageName = this.getPackageName();
        return StringTools.isBlank((String)packageName) ? this.name : this.name.substring(packageName.length() + 1);
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getSelectionTextRange();
    }

    public TextRange getSelectionTextRange() {
        return this.resourceType.getNameTextRange();
    }

    @Override
    public IResource getResource() {
        return this.resourceType.getFile();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return this.resourceType;
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.resourceType.getFile());
    }

    @Override
    public boolean isFor(String typeName) {
        return ObjectTools.equals((Object)typeName, (Object)this.name);
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return ObjectTools.equals((Object)packageFragment.getElementName(), (Object)this.getPackageName());
    }

    protected String getPackageName() {
        return this.getJavaResourceType().getTypeBinding().getPackageName();
    }

    @Override
    public IJavaElement getJavaElement() {
        try {
            return this.getJavaProject().findType(this.name);
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.instance().logError(ex);
            return null;
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

