/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.views;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.views.JpaStructurePage;
import org.eclipse.jpt.jpa.ui.selection.JpaEditorManager;
import org.eclipse.jpt.jpa.ui.selection.JpaViewManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class JpaStructureView
extends PageBookView {
    public static final String ID = "org.eclipse.jpt.ui.jpaStructureView";
    private volatile Manager manager;
    private volatile ResourceManager resourceManager;

    public void createPartControl(Composite parent) {
        this.manager = this.buildManager();
        this.resourceManager = this.buildResourceManager();
        super.createPartControl(parent);
    }

    private Manager buildManager() {
        JpaViewManager.PageManager pageManager = this.getPageManager();
        return pageManager == null ? null : new Manager(pageManager);
    }

    private JpaViewManager.PageManager getPageManager() {
        return (JpaViewManager.PageManager)this.getAdapter(JpaViewManager.PageManager.class);
    }

    private ResourceManager buildResourceManager() {
        JpaWorkbench jpaWorkbench = this.getJpaWorkbench();
        return jpaWorkbench != null ? jpaWorkbench.buildLocalResourceManager() : new LocalResourceManager(JFaceResources.getResources((Display)this.getWorkbench().getDisplay()));
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)PlatformTools.getAdapter((Object)this.getWorkbench(), JpaWorkbench.class);
    }

    private IWorkbench getWorkbench() {
        return this.getSite().getWorkbenchWindow().getWorkbench();
    }

    protected IPage createDefaultPage(PageBook book) {
        DefaultPage page = new DefaultPage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        return page == null ? null : page.getActiveEditor();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        this.partActivated(part);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IEditorPart editor = (IEditorPart)part;
        if (this.manager == null) {
            return null;
        }
        JpaEditorManager editorManager = this.manager.getEditorManager(editor);
        if (editorManager == null) {
            return null;
        }
        JpaStructurePage page = new JpaStructurePage(this, editorManager, this.resourceManager);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec((IWorkbenchPart)editor, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        JpaStructurePage page = (JpaStructurePage)pageRecord.page;
        page.dispose();
        pageRecord.dispose();
    }

    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)((Object)this));
    }

    static class DefaultPage
    extends Page {
        private Composite composite;

        DefaultPage() {
        }

        public void createControl(Composite parent) {
            this.composite = new Composite(parent, 0);
            this.composite.setLayout((Layout)new FillLayout());
            Label label = new Label(this.composite, 16576);
            label.setText(JptJpaUiMessages.JPA_STRUCTURE_VIEW_STRUCTURE_NOT_AVAILABLE);
        }

        public Control getControl() {
            return this.composite;
        }

        public void setFocus() {
            this.composite.setFocus();
        }
    }

    class Manager
    implements JpaViewManager {
        private final JpaViewManager.PageManager pageManager;

        Manager(JpaViewManager.PageManager pageManager) {
            if (pageManager == null) {
                throw new NullPointerException();
            }
            this.pageManager = pageManager;
            this.pageManager.addViewManager(this);
        }

        public IViewPart getView() {
            return JpaStructureView.this;
        }

        JpaEditorManager getEditorManager(IEditorPart editor) {
            return this.pageManager.getEditorManager(editor);
        }

        void dispose() {
            this.pageManager.removeViewManager(this);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

