/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jst.j2ee.internal.common.operations.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMethod
implements Method {
    private MethodDeclaration method;

    public SourceMethod(MethodDeclaration method) {
        this.method = method;
    }

    @Override
    public String getSignature() {
        List parameters = this.method.parameters();
        ArrayList<String> parameterTypesList = new ArrayList<String>();
        for (SingleVariableDeclaration parameter : parameters) {
            parameterTypesList.add(parameter.getType().resolveBinding().getQualifiedName());
        }
        String[] parameterTypes = parameterTypesList.toArray(new String[0]);
        String returnType = this.method.getReturnType2().resolveBinding().getQualifiedName();
        return Signature.createMethodSignature((String[])parameterTypes, (String)returnType);
    }

    @Override
    public String getName() {
        return this.method.getName().getIdentifier();
    }

    @Override
    public String getContainingJavaClass() {
        TypeDeclaration type = (TypeDeclaration)this.method.getParent();
        return type.getName().getIdentifier();
    }

    @Override
    public String getReturnType() {
        return this.method.getReturnType2().resolveBinding().getName();
    }

    @Override
    public String getDefaultReturnValue() {
        Type returnType = this.method.getReturnType2();
        if (returnType.isPrimitiveType()) {
            PrimitiveType.Code code = ((PrimitiveType)returnType).getPrimitiveTypeCode();
            if (code == PrimitiveType.VOID) {
                return null;
            }
            if (code == PrimitiveType.BOOLEAN) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Override
    public Collection<String> getReturnTypeImports() {
        ArrayList<String> result = new ArrayList<String>();
        Type returnType = this.method.getReturnType2();
        this.getTypeImports(returnType, result);
        return result;
    }

    @Override
    public String getParamsForCall() {
        return this.getParams(false, true);
    }

    @Override
    public String getParamsForDeclaration() {
        return this.getParams(true, true);
    }

    @Override
    public String getParamsForJavadoc() {
        return this.getParams(true, false);
    }

    @Override
    public Collection<String> getParameterImports() {
        ArrayList<String> result = new ArrayList<String>();
        List parameters = this.method.parameters();
        for (SingleVariableDeclaration parameter : parameters) {
            Type type = parameter.getType();
            this.getTypeImports(type, result);
        }
        return result;
    }

    @Override
    public String getExceptions() {
        StringBuffer exceptions = new StringBuffer();
        List exceptionTypes = this.method.thrownExceptions();
        int i = 0;
        while (i < exceptionTypes.size()) {
            exceptions.append(exceptionTypes.get(i));
            if (i < exceptionTypes.size() - 1) {
                exceptions.append(", ");
            }
            ++i;
        }
        return exceptions.toString();
    }

    public boolean equals(Object o) {
        Method obj = (Method)o;
        return this.getName().equals(obj.getName()) && this.getSignature().equals(obj.getSignature());
    }

    public int hashCode() {
        return this.getName().hashCode() * this.getSignature().hashCode();
    }

    private String getParams(boolean types, boolean names) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = this.method.parameters().iterator();
        while (iterator.hasNext()) {
            SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
            if (types) {
                result.append(parameter.getType());
            }
            if (types && names) {
                result.append(" ");
            }
            if (names) {
                result.append(parameter.getName());
            }
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private void getTypeImports(Type type, List<String> result) {
        if (type.isArrayType()) {
            this.getArrayTypeImports(type, result);
        } else if (type.isParameterizedType()) {
            this.getParameterizedTypeImports(type, result);
        } else if (type.isPrimitiveType()) {
            this.getPrimitiveTypeImports(type, result);
        } else if (type.isSimpleType()) {
            this.getSimpleTypeImports(type, result);
        } else if (type.isQualifiedType()) {
            this.getQualifiedTypeImports(type, result);
        } else if (type.isWildcardType()) {
            this.getWildcardTypeImports(type, result);
        }
    }

    private void getArrayTypeImports(Type type, List<String> result) {
        ArrayType arrayType = (ArrayType)type;
        Type componentType = arrayType.getComponentType();
        this.getTypeImports(componentType, result);
    }

    private void getParameterizedTypeImports(Type type, List<String> result) {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type mainType = parameterizedType.getType();
        this.getTypeImports(mainType, result);
        List arguments = parameterizedType.typeArguments();
        for (Type argument : arguments) {
            this.getTypeImports(argument, result);
        }
    }

    private void getPrimitiveTypeImports(Type type, List<String> result) {
    }

    private void getSimpleTypeImports(Type type, List<String> result) {
        ITypeBinding binding = type.resolveBinding();
        if (binding != null) {
            result.add(binding.getQualifiedName());
        }
    }

    private void getQualifiedTypeImports(Type type, List<String> result) {
        QualifiedType qualifiedType = (QualifiedType)type;
        result.add(qualifiedType.getQualifier() + "." + qualifiedType.getName());
    }

    private void getWildcardTypeImports(Type type, List<String> result) {
        WildcardType wildcardType = (WildcardType)type;
        Type bound = wildcardType.getBound();
        if (bound != null) {
            this.getTypeImports(bound, result);
        }
    }
}

