/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.policy.IdentifierOrderedIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.strategy.IIdentifiableStrategy;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.view.model.AbstractTagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.CompositeTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCoreTraceOptions;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletDocumentFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.FaceletTagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.IFaceletTagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.LibraryOperation;
import org.eclipse.jst.jsf.facelet.core.internal.registry.LibraryOperationFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.FaceletTagIndex;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IProjectTaglibDescriptor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.FaceletNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FaceletTagRegistry
extends AbstractTagRegistry
implements IManagedObject {
    private final ConcurrentLinkedQueue<LibraryOperation> _changeOperations = new ConcurrentLinkedQueue();
    private final IProject _project;
    private final Map<String, FaceletNamespace> _nsResolved;
    private final Set<FaceletNamespace> _unResolved;
    private final CompositeTagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper> _resolver;
    private final FaceletDocumentFactory _factory;
    private final LibraryOperationFactory _operationFactory = new LibraryOperationFactory(this);
    private final ILock _lock = Job.getJobManager().newLock();
    private volatile boolean _isInitialized;
    private ChangeJob _changeJob;
    private MyTaglibListener _listener;

    FaceletTagRegistry(IProject project) {
        this._project = project;
        this._nsResolved = new HashMap<String, FaceletNamespace>();
        this._unResolved = new HashSet<FaceletNamespace>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("org.eclipse.jst.jsf.facelet.core.FaceletTagResolvingStrategy");
        IdentifierOrderedIteratorPolicy policy = new IdentifierOrderedIteratorPolicy(ids);
        policy.setExcludeNonExplicitValues(true);
        this._resolver = new CompositeTagResolvingStrategy((IIteratorPolicy)policy);
        this._factory = new FaceletDocumentFactory(project);
        this._resolver.addStrategy((IIdentifiableStrategy)new FaceletTagResolvingStrategy(this._project, this._factory));
        this._changeJob = new ChangeJob(project.getName());
    }

    public Collection<FaceletNamespace> getAllTagLibraries() {
        boolean setEndRule = false;
        try {
            HashSet<FaceletNamespace> allTagLibraries = new HashSet<FaceletNamespace>();
            if (!this._isInitialized) {
                if (Job.getJobManager().currentRule() == null) {
                    Job.getJobManager().beginRule((ISchedulingRule)this._project, null);
                    setEndRule = true;
                }
                this._lock.acquire();
                if (!this._isInitialized) {
                    try {
                        this.initialize(false);
                        this._isInitialized = true;
                    }
                    catch (JavaModelException e) {
                        FaceletCorePlugin.log("Problem during initialization", e);
                    }
                    catch (CoreException e) {
                        FaceletCorePlugin.log("Problem during initialization", e);
                    }
                }
            } else {
                this._lock.acquire();
            }
            allTagLibraries.addAll(this._nsResolved.values());
            allTagLibraries.addAll(this._unResolved);
            HashSet<FaceletNamespace> hashSet = allTagLibraries;
            return hashSet;
        }
        finally {
            this._lock.release();
            if (setEndRule) {
                Job.getJobManager().endRule((ISchedulingRule)this._project);
            }
        }
    }

    private void initialize(boolean fireEvent) throws JavaModelException, CoreException {
        IProjectTaglibDescriptor tagDesc;
        if (!this._project.exists() || !this._project.hasNature("org.eclipse.jdt.core.javanature")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.facelet.core", "Project either does not exists or is not a java project: " + this._project));
        }
        FaceletTagIndex index = FaceletTagIndex.getInstance(this._project.getWorkspace());
        try {
            tagDesc = (IProjectTaglibDescriptor)index.getInstance((IResource)this._project);
        }
        catch (ObjectManager.ManagedObjectException managedObjectException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.facelet.core", "Error instantiating facelet tag index for project: " + this._project.getName(), (Throwable)managedObjectException));
        }
        if (tagDesc != null) {
            for (IFaceletTagRecord iFaceletTagRecord : tagDesc.getTagLibraries()) {
                if (iFaceletTagRecord.getURI() == null) continue;
                this.initialize(iFaceletTagRecord, fireEvent);
            }
            this._listener = new MyTaglibListener();
            tagDesc.addListener(this._listener);
        }
    }

    FaceletNamespace initialize(IFaceletTagRecord tagRecord, boolean fireEvent) {
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
            FaceletCoreTraceOptions.log("TLDTagRegistry.initialize_TagRecord: Initializing new tld record: " + tagRecord.toString());
        }
        FaceletNamespace ns = new FaceletNamespace(tagRecord, (ITagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper, String>)this._resolver);
        this._nsResolved.put(tagRecord.getURI(), ns);
        if (fireEvent) {
            this.fireEvent(new ITagRegistry.TagRegistryChangeEvent((ITagRegistry)this, ITagRegistry.TagRegistryChangeEvent.EventType.ADDED_NAMESPACE, Collections.singletonList(ns)));
        }
        return ns;
    }

    void remove(IFaceletTagRecord tagRecord) {
        FaceletNamespace ns = this._nsResolved.remove(tagRecord.getURI());
        if (ns != null) {
            this.fireEvent(new ITagRegistry.TagRegistryChangeEvent((ITagRegistry)this, ITagRegistry.TagRegistryChangeEvent.EventType.REMOVED_NAMESPACE, Collections.singletonList(ns)));
        }
    }

    public Namespace getTagLibrary(String uri) {
        this.getAllTagLibraries();
        return this._nsResolved.get(uri);
    }

    protected Job getRefreshJob(final boolean flushCaches) {
        return new Job("Refreshing Facelet tag registry for " + this._project.getName()){

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                boolean setEndRule = false;
                try {
                    if (Job.getJobManager().currentRule() == null) {
                        Job.getJobManager().beginRule((ISchedulingRule)FaceletTagRegistry.this._project, null);
                        setEndRule = true;
                    }
                    FaceletTagRegistry.this._lock.acquire();
                    if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
                        JSFCoreTraceOptions.log((String)"FaceletTagRegistry.refresh: start");
                    }
                    ArrayList namespaces = new ArrayList(FaceletTagRegistry.this._nsResolved.values());
                    if (flushCaches) {
                        FaceletTagIndex.getInstance(FaceletTagRegistry.this._project.getWorkspace()).flush(FaceletTagRegistry.this._project);
                    } else {
                        FaceletTagRegistry.this.checkpoint();
                    }
                    FaceletTagRegistry.this._nsResolved.clear();
                    FaceletTagRegistry.this.fireEvent(new ITagRegistry.TagRegistryChangeEvent((ITagRegistry)FaceletTagRegistry.this, ITagRegistry.TagRegistryChangeEvent.EventType.REMOVED_NAMESPACE, namespaces));
                    try {
                        FaceletTagRegistry.this.initialize(true);
                    }
                    catch (JavaModelException e) {
                        Status status = new Status(4, "org.eclipse.jst.jsf.facelet.core", "Problem refreshing registry", (Throwable)e);
                        FaceletTagRegistry.this._lock.release();
                        if (setEndRule) {
                            Job.getJobManager().endRule((ISchedulingRule)FaceletTagRegistry.this._project);
                        }
                        return status;
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "org.eclipse.jst.jsf.facelet.core", "Problem refreshing registry", (Throwable)e);
                        FaceletTagRegistry.this._lock.release();
                        if (setEndRule) {
                            Job.getJobManager().endRule((ISchedulingRule)FaceletTagRegistry.this._project);
                        }
                        return status;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    FaceletTagRegistry.this._lock.release();
                    if (setEndRule) {
                        Job.getJobManager().endRule((ISchedulingRule)FaceletTagRegistry.this._project);
                    }
                }
            }
        };
    }

    private void addLibraryOperation(LibraryOperation operation) {
        this._changeOperations.add(operation);
        this._changeJob.schedule();
    }

    protected void doDispose() {
        if (this._listener != null) {
            FaceletTagIndex index = FaceletTagIndex.getInstance(this._project.getWorkspace());
            try {
                IProjectTaglibDescriptor instance = (IProjectTaglibDescriptor)index.getInstance((IResource)this._project);
                instance.removeListener(this._listener);
            }
            catch (ObjectManager.ManagedObjectException e) {
                FaceletCorePlugin.log("Disposing facelet tag registry for project: " + this._project.getName(), e);
            }
            this._nsResolved.clear();
        }
    }

    protected void cleanupPersistentState() {
    }

    public void checkpoint() {
    }

    private class ChangeJob
    extends Job {
        private int _rescheduleTime;

        public ChangeJob(String projectName) {
            super("Update job for project " + projectName);
            this._rescheduleTime = -1;
            this.setRule((ISchedulingRule)FaceletTagRegistry.this._project);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                FaceletTagRegistry.this._lock.acquire();
                this._rescheduleTime = -1;
                LibraryOperation operation = null;
                MultiStatus multiStatus = new MultiStatus("org.eclipse.jst.jsf.core", 0, "Result of change job", new Throwable());
                while ((operation = (LibraryOperation)FaceletTagRegistry.this._changeOperations.poll()) != null) {
                    this._rescheduleTime = 10000;
                    operation.run();
                    multiStatus.add(operation.getResult());
                }
                if (this._rescheduleTime >= 0 && !monitor.isCanceled()) {
                    this.schedule(this._rescheduleTime);
                }
                MultiStatus multiStatus2 = multiStatus;
                return multiStatus2;
            }
            finally {
                FaceletTagRegistry.this._lock.release();
            }
        }
    }

    private class MyTaglibListener
    extends Listener {
        private MyTaglibListener() {
        }

        public void changed(Listener.TaglibChangedEvent event) {
            switch (event.getChangeType()) {
                case ADDED: {
                    FaceletTagRegistry.this.addLibraryOperation(FaceletTagRegistry.this._operationFactory.createAddOperation(event.getNewValue()));
                    break;
                }
                case CHANGED: {
                    FaceletTagRegistry.this.addLibraryOperation(FaceletTagRegistry.this._operationFactory.createChangeOperation(event.getNewValue()));
                    break;
                }
                case REMOVED: {
                    FaceletTagRegistry.this.addLibraryOperation(FaceletTagRegistry.this._operationFactory.createRemoveOperation(event.getOldValue()));
                }
            }
        }
    }
}

