/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.desktop;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.autagent.agent.AutAgent;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopIntegration
implements PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(DesktopIntegration.class);
    private boolean m_isSystraySupported;
    private TrayIcon m_trayIcon;
    private int m_port = 0;
    private List<String> m_auts = new ArrayList<String>();

    public DesktopIntegration(final AutAgent autAgent) {
        this.m_isSystraySupported = SystemTray.isSupported();
        if (this.m_isSystraySupported) {
            SystemTray tray = SystemTray.getSystemTray();
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL imageURL = EnvironmentUtils.isMacOS() ? classLoader.getResource("resources/gdagent_osx.png") : classLoader.getResource("resources/gdagent.png");
            Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            };
            PopupMenu popup = new PopupMenu();
            final CheckboxMenuItem strictModeItem = new CheckboxMenuItem("Strict AUT Management");
            autAgent.addPropertyChangeListener("killDuplicateAuts", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newValue = evt.getNewValue();
                    if (newValue instanceof Boolean) {
                        boolean isKillDuplicateAuts = (Boolean)newValue;
                        strictModeItem.setState(isKillDuplicateAuts);
                    } else {
                        LOG.error("Expected new value for property to be of type " + Boolean.class.getName());
                    }
                }
            });
            boolean isKillDuplicateAuts = autAgent.isKillDuplicateAuts();
            strictModeItem.setState(isKillDuplicateAuts);
            strictModeItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    autAgent.setKillDuplicateAuts(e.getStateChange() == 1);
                }
            });
            MenuItem defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener(exitListener);
            popup.add(strictModeItem);
            popup.addSeparator();
            popup.add(defaultItem);
            this.m_trayIcon = new TrayIcon(image, "AUT Agent", popup);
            this.m_trayIcon.setImageAutoSize(true);
            try {
                tray.add(this.m_trayIcon);
            }
            catch (AWTException aWTException) {
                this.m_isSystraySupported = false;
            }
        }
    }

    private void updateStatus() {
        if (this.m_isSystraySupported) {
            this.m_trayIcon.setToolTip(this.buildToolTip());
        }
    }

    private String buildToolTip() {
        StringBuilder tt = new StringBuilder("AUT Agent\n");
        tt.append(" Port used: ");
        tt.append(this.m_port);
        if (!this.m_auts.isEmpty()) {
            tt.append('\n');
            tt.append(' ');
            tt.append(this.m_auts.size());
            tt.append(" running AUT");
            if (this.m_auts.size() == 1) {
                tt.append(':');
            } else {
                tt.append("s:");
            }
            for (String aut : this.m_auts) {
                tt.append('\n');
                tt.append(' ');
                tt.append(aut);
            }
        }
        return tt.toString();
    }

    public void setPort(int port) {
        this.m_port = port;
        this.updateStatus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("auts")) {
            AutIdentifier aut;
            if (evt.getNewValue() instanceof AutIdentifier) {
                aut = (AutIdentifier)evt.getNewValue();
                this.m_auts.add(aut.getExecutableName());
            }
            if (evt.getOldValue() instanceof AutIdentifier) {
                aut = (AutIdentifier)evt.getOldValue();
                this.m_auts.remove(aut.getExecutableName());
            }
        }
        this.updateStatus();
    }
}

