/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.persistence.PersistenceException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang.Validate;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.archive.XmlExporter;
import org.eclipse.jubula.client.archive.XmlImporter;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.archive.schema.ContentDocument;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlStorage {
    public static final String RECOMMENDED_CHAR_ENCODING = "UTF-8";
    private static final String[] SUPPORTED_CHAR_ENCODINGS = new String[]{"UTF-8", "UTF-16"};
    private static final String SCHEMA_NAMESPACE = "http://www.eclipse.org/jubula/client/archive/schema";
    private static final String EXEC_TC_XML_ELEMENT_NAME = "usedTestcase";
    private static final String XPATH_FOR_EXEC_TCS = "declare namespace s='http://www.eclipse.org/jubula/client/archive/schema' .//s:usedTestcase";
    private static Logger log = LoggerFactory.getLogger(XmlStorage.class);
    private static final String OLD_SCHEMA_NAMESPACE = "http://www.bredexsw.com/guidancer/client/importer/gdschema";

    private static InputStream save(IProjectPO project, boolean includeTestResultSummaries, IProgressMonitor monitor) throws ProjectDeletedException, PMException {
        XmlOptions genOpts = new XmlOptions();
        genOpts.setCharacterEncoding(RECOMMENDED_CHAR_ENCODING);
        genOpts.setSaveInner();
        genOpts.setSaveAggressiveNamespaces();
        genOpts.setUseDefaultNamespace();
        ContentDocument contentDoc = ContentDocument.Factory.newInstance(genOpts);
        ContentDocument.Content content = contentDoc.addNewContent();
        Project prj = content.addNewProject();
        try {
            new XmlExporter(monitor).fillProject(prj, project, includeTestResultSummaries);
        }
        catch (OperationCanceledException operationCanceledException) {
            log.info(Messages.ExportOperationCanceled);
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        XmlOptions options = new XmlOptions(genOpts);
        ArrayList errors = new ArrayList();
        options.setErrorListener(errors);
        if (!contentDoc.validate(options)) {
            StringBuilder msgs = new StringBuilder("\n");
            for (Object msg : errors) {
                msgs.append(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(Messages.ValidateFailed) + ":", (Object)msgs);
                log.debug(String.valueOf(Messages.ValidateFailed) + ":", (Object)contentDoc);
            }
            throw new PMSaveException("XML" + Messages.ValidateFailed + msgs.toString(), MessageIDs.E_FILE_IO);
        }
        return contentDoc.newInputStream(genOpts);
    }

    public static IProjectPO load(InputStream projectXmlStream, boolean assignNewGuid, Integer majorVersion, Integer minorVersion, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, IProgressMonitor monitor, IProgressConsole io, boolean skipTrackingInformation) throws PMReadException, JBVersionException, InterruptedException {
        try {
            ContentDocument contentDoc = XmlStorage.getContent(projectXmlStream);
            Project projectXml = contentDoc.getContent().getProject();
            int numExecTestCases = projectXml.selectPath(XPATH_FOR_EXEC_TCS).length;
            monitor.beginTask("", numExecTestCases + 1);
            monitor.worked(1);
            XmlImporter xmlImporter = new XmlImporter(monitor, io, skipTrackingInformation);
            if (assignNewGuid) {
                return xmlImporter.createProject(projectXml, assignNewGuid, paramNameMapper, compNameCache);
            }
            if (majorVersion != null && minorVersion != null) {
                return xmlImporter.createProject(projectXml, majorVersion, minorVersion, paramNameMapper, compNameCache);
            }
            return xmlImporter.createProject(projectXml, paramNameMapper, compNameCache);
        }
        catch (XmlException xmlException) {
            throw new PMReadException(Messages.InvalidImportFile, MessageIDs.E_LOAD_PROJECT);
        }
        catch (InvalidDataException e) {
            throw new PMReadException(Messages.InvalidImportFile, e.getErrorId());
        }
    }

    private static ContentDocument getContent(InputStream projectXmlStream) throws XmlException, PMReadException {
        HashMap<String, String> substitutes = new HashMap<String, String>();
        substitutes.put(OLD_SCHEMA_NAMESPACE, SCHEMA_NAMESPACE);
        XmlOptions options = new XmlOptions();
        options.setLoadSubstituteNamespaces(substitutes);
        ContentDocument contentDoc = null;
        try {
            try {
                contentDoc = ContentDocument.Factory.parse(projectXmlStream, options);
                ArrayList errors = new ArrayList();
                options.setErrorListener(errors);
                if (!contentDoc.validate(options)) {
                    StringBuilder msgs = new StringBuilder("\n");
                    for (Object msg : errors) {
                        msgs.append(msg);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.valueOf(Messages.ValidateFailed) + ":", (Object)msgs);
                        log.debug(String.valueOf(Messages.ValidateFailed) + ":", (Object)contentDoc);
                    }
                    throw new PMReadException(String.valueOf(Messages.InvalidImportFile) + msgs.toString(), MessageIDs.E_LOAD_PROJECT);
                }
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new PMReadException(e.getLocalizedMessage(), MessageIDs.E_LOAD_PROJECT);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)projectXmlStream);
        }
        return contentDoc;
    }

    public static InputStream save(IProjectPO proj, String fileName, boolean includeTestResultSummaries, IProgressMonitor monitor, boolean writeToSystemTempDir, List<File> listOfProjectFiles) throws ProjectDeletedException, PMException {
        monitor.beginTask(Messages.XmlStorageSavingProject, XmlStorage.getWorkToSave(proj));
        Validate.notNull((Object)proj);
        Object fWriter = null;
        try {
            InputStream projXMLStream = XmlStorage.save(proj, includeTestResultSummaries, monitor);
            if (fileName == null) {
                InputStream inputStream = projXMLStream;
                return inputStream;
            }
            try {
                if (writeToSystemTempDir) {
                    File fileInTempDir = XmlStorage.createTempFile(fileName);
                    if (listOfProjectFiles != null) {
                        listOfProjectFiles.add(fileInTempDir);
                    }
                    fWriter = new FileWriterWithEncoding(fileInTempDir, RECOMMENDED_CHAR_ENCODING);
                } else {
                    fWriter = new FileWriterWithEncoding(fileName, RECOMMENDED_CHAR_ENCODING);
                }
                IOCanceller canceller = new IOCanceller(monitor, (FileWriterWithEncoding)fWriter);
                canceller.startTask();
                IOUtils.copy((InputStream)projXMLStream, (Writer)fWriter, (String)RECOMMENDED_CHAR_ENCODING);
                canceller.taskFinished();
            }
            catch (FileNotFoundException e) {
                log.debug(String.valueOf(Messages.File) + " " + Messages.NotFound, (Throwable)e);
                throw new PMSaveException(String.valueOf(Messages.File) + " " + fileName + Messages.NotFound + ":" + " " + e.toString(), MessageIDs.E_FILE_IO);
            }
            catch (IOException e) {
                if (!monitor.isCanceled()) {
                    log.debug(Messages.GeneralIoExeption, (Throwable)e);
                    throw new PMSaveException(String.valueOf(Messages.GeneralIoExeption) + e.toString(), MessageIDs.E_FILE_IO);
                }
            }
            catch (PersistenceException e) {
                log.debug(String.valueOf(Messages.CouldNotInitializeProxy) + ".", (Throwable)e);
                throw new PMSaveException(e.getMessage(), MessageIDs.E_DATABASE_GENERAL);
            }
        }
        finally {
            if (fWriter != null) {
                try {
                    fWriter.close();
                }
                catch (IOException e) {
                    log.error(String.valueOf(Messages.CantCloseOOS) + fWriter.toString(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static File createTempFile(String fileName) throws IOException {
        String fileNameSuffix;
        String fileNamePrefix;
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex < 0) {
            fileNamePrefix = fileName;
            fileNameSuffix = "";
        } else {
            fileNamePrefix = String.valueOf(fileName.substring(0, dotIndex)) + "_";
            fileNameSuffix = fileName.substring(dotIndex);
        }
        File fileInTempDir = File.createTempFile(fileNamePrefix, fileNameSuffix);
        return fileInTempDir;
    }

    private static InputStream openStreamToProjectURL(URL fileURL) throws PMReadException {
        try {
            XmlStorage.checkCharacterEncoding(fileURL);
            return fileURL.openStream();
        }
        catch (IOException e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            throw new PMReadException(e.toString(), MessageIDs.E_FILE_IO);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String checkCharacterEncoding(URL xmlProjectURL) throws IOException {
        var4_1 = XmlStorage.SUPPORTED_CHAR_ENCODINGS;
        var3_2 = XmlStorage.SUPPORTED_CHAR_ENCODINGS.length;
        var2_3 = 0;
        while (var2_3 < var3_2) {
            encoding = var4_1[var2_3];
            var5_5 = null;
            var6_7 = null;
            try {
                xmlProjectStream = xmlProjectURL.openStream();
                try {
                    block17: {
                        block18: {
                            reader = new BufferedReader(new InputStreamReader(xmlProjectStream, encoding));
                            try {
                                firstLine = reader.readLine();
                                if (firstLine != null && firstLine.contains(encoding)) {
                                    v0 = encoding;
                                    return v0;
                                }
                                break block17;
                            }
                            finally {
                                if (reader == null) break block18;
                                reader.close();
                            }
                        }
                        if (xmlProjectStream != null) {
                            xmlProjectStream.close();
                        }
                        return v0;
                    }
                    ** if (xmlProjectStream == null) goto lbl-1000
                }
                catch (Throwable var6_8) {
                    if (var5_5 == null) {
                        var5_5 = var6_8;
                    } else if (var5_5 != var6_8) {
                        var5_5.addSuppressed(var6_8);
                    }
                    if (xmlProjectStream == null) throw var5_5;
                    xmlProjectStream.close();
                    throw var5_5;
                }
lbl-1000:
                // 1 sources

                {
                    xmlProjectStream.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
            ++var2_3;
        }
        throw new IOException(String.valueOf(Messages.NoSupportedFileEncoding) + "!");
    }

    public IProjectPO readProject(URL fileURL, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, boolean assignNewGuids, IProgressMonitor monitor, IProgressConsole io) throws PMReadException, JBVersionException, InterruptedException {
        return XmlStorage.load(XmlStorage.openStreamToProjectURL(fileURL), assignNewGuids, null, null, paramNameMapper, compNameCache, monitor, io, false);
    }

    public static int getWorkToSave(IProjectPO project) {
        return new XmlExporter((IProgressMonitor)new NullProgressMonitor()).getPredictedWork(project);
    }

    public static int getWorkToSave(List<IProjectPO> projectsToSave) {
        int totalWork = 0;
        for (IProjectPO project : projectsToSave) {
            totalWork += XmlStorage.getWorkToSave(project);
        }
        return totalWork;
    }

    private static class IOCanceller
    extends TimerTask {
        private IProgressMonitor m_monitor;
        private FileWriterWithEncoding m_writer;
        private Timer m_timer;

        public IOCanceller(IProgressMonitor monitor, FileWriterWithEncoding writer) {
            this.m_monitor = monitor;
            this.m_writer = writer;
            this.m_timer = new Timer();
        }

        public void startTask() {
            this.m_timer.schedule((TimerTask)this, 1000L, 1000L);
        }

        public void taskFinished() {
            this.m_timer.cancel();
        }

        private void checkTask() {
            if (this.m_monitor.isCanceled()) {
                try {
                    this.m_writer.close();
                }
                catch (IOException e) {
                    log.error(Messages.ErrorWhileCloseOS, (Throwable)e);
                }
            }
        }

        @Override
        public void run() {
            this.checkTask();
        }
    }
}

