/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.commands.RegisteredAutListCommand;
import org.eclipse.jubula.client.core.communication.AutAgentConnection;
import org.eclipse.jubula.client.core.events.AutAgentEvent;
import org.eclipse.jubula.client.core.events.IServerEventListener;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.communication.message.GetRegisteredAutListMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutAgentRegistration
implements IServerEventListener,
IAutRegistrationListener {
    private static final Logger LOG = LoggerFactory.getLogger(AutAgentRegistration.class);
    private static AutAgentRegistration instance;
    private Set<IAutRegistrationListener> m_listeners = new CopyOnWriteArraySet<IAutRegistrationListener>();
    private List<AutIdentifier> m_registeredAuts = new ArrayList<AutIdentifier>();

    private AutAgentRegistration() {
        ClientTest.instance().addAutAgentEventListener(this);
    }

    public static synchronized AutAgentRegistration getInstance() {
        if (instance == null) {
            instance = new AutAgentRegistration();
        }
        return instance;
    }

    public void addListener(IAutRegistrationListener l) {
        this.m_listeners.add(l);
    }

    public void removeListener(IAutRegistrationListener l) {
        this.m_listeners.remove(l);
    }

    public synchronized void fireAutRegistration(AutRegistrationEvent event) {
        switch (event.getStatus()) {
            case Register: {
                this.m_registeredAuts.add(event.getAutId());
                break;
            }
            case Deregister: {
                this.m_registeredAuts.remove(event.getAutId());
                break;
            }
        }
        for (IAutRegistrationListener l : this.m_listeners) {
            try {
                l.handleAutRegistration(event);
            }
            catch (Throwable t) {
                LOG.error(String.valueOf(Messages.ErrorWhileNotifyingListeners) + ".", t);
            }
        }
    }

    public synchronized List<AutIdentifier> getRegisteredAuts() {
        return new LinkedList<AutIdentifier>(this.m_registeredAuts);
    }

    @Override
    public void stateChanged(AutAgentEvent event) {
        switch (event.getState()) {
            case 2: {
                this.clearRegisteredAuts();
                break;
            }
            case 1: {
                try {
                    AutAgentConnection.getInstance().request((Message)new GetRegisteredAutListMessage(), new RegisteredAutListCommand(this), 5000);
                }
                catch (CommunicationException ce) {
                    LOG.error(Messages.ErrorWhileGettingListOfRegisteredAUTs, (Throwable)ce);
                }
                break;
            }
        }
    }

    @Override
    public void handleAutRegistration(AutRegistrationEvent event) {
        this.fireAutRegistration(event);
    }

    private synchronized void clearRegisteredAuts() {
        for (AutIdentifier autId : this.getRegisteredAuts()) {
            this.fireAutRegistration(new AutRegistrationEvent(autId, AutRegistrationEvent.RegistrationStatus.Deregister));
        }
    }

    public static Map<IAUTMainPO, Collection<AutIdentifier>> getRunningAuts(IProjectPO project, Collection<AutIdentifier> availableAutIds) {
        HashSet<AutIdentifier> availableIds = new HashSet<AutIdentifier>();
        if (availableAutIds == null || availableAutIds.isEmpty()) {
            availableIds.addAll(AutAgentRegistration.getInstance().getRegisteredAuts());
        } else {
            availableIds.addAll(availableAutIds);
        }
        HashMap<IAUTMainPO, Collection<AutIdentifier>> runningAuts = new HashMap<IAUTMainPO, Collection<AutIdentifier>>();
        for (AutIdentifier autId : availableIds) {
            IAUTMainPO aut = AutAgentRegistration.getAutForId(autId, project);
            if (aut == null) continue;
            if (runningAuts.get(aut) == null) {
                runningAuts.put(aut, new HashSet());
            }
            ((Collection)runningAuts.get(aut)).add(autId);
        }
        return runningAuts;
    }

    public static IAUTMainPO getAutForId(AutIdentifier autId, IProjectPO project) {
        if (project != null && autId != null) {
            String autIdString = autId.getExecutableName();
            for (IAUTMainPO aut : project.getAutMainList()) {
                if (aut.getAutIds().contains(autIdString)) {
                    return aut;
                }
                for (IAUTConfigPO autConfig : aut.getAutConfigSet()) {
                    if (!autIdString.equals(autConfig.getConfigMap().get("AUT_ID"))) continue;
                    return aut;
                }
            }
        }
        return null;
    }
}

