/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.jubula.client.core.businessprocess.IXMLReportWriter;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlResultReportWriter
implements IXMLReportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlResultReportWriter.class);
    private OutputStreamWriter m_writer;

    public XmlResultReportWriter(OutputStreamWriter writer) {
        this.m_writer = writer;
    }

    public void write(Document document) {
        OutputFormat xmlFormat = OutputFormat.createPrettyPrint();
        xmlFormat.setEncoding(this.m_writer.getEncoding());
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter((Writer)this.m_writer, xmlFormat);
            xmlWriter.write(document);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(String.valueOf(Messages.ErrorFileWriting) + ".", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(String.valueOf(Messages.ErrorFileWriting) + ".", (Throwable)e);
        }
    }
}

