/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.events.AUTEvent;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.AUTServerStateMessage;
import org.eclipse.jubula.communication.message.AUTStartMessage;
import org.eclipse.jubula.communication.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTServerStateCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(AUTServerStateCommand.class);
    private AUTServerStateMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (AUTServerStateMessage)message;
    }

    public Message execute() {
        int state = this.m_message.getState();
        switch (state) {
            case 0: {
                log.info(Messages.AUTServerIsReady);
                ClientTest.instance().fireAUTStateChanged(new AUTEvent(8));
                return new AUTStartMessage();
            }
            case 1: {
                log.info(String.valueOf(Messages.TheAUTCouldNotFound) + "." + " " + this.m_message.getDescription());
                ClientTest.instance().fireAUTStateChanged(new AUTEvent(4));
                break;
            }
            case 2: {
                log.info(String.valueOf(Messages.TheMainMethodCouldNotLoaded) + "." + " ");
                ClientTest.instance().fireAUTStateChanged(new AUTEvent(5));
                break;
            }
            case 3: {
                log.info(String.valueOf(Messages.AUTClassFormatNotSupportedByUsedJRE) + "." + " ");
                ClientTest.instance().fireAUTStateChanged(new AUTEvent(7));
            }
        }
        return null;
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + "timeout() called");
    }
}

