/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.events;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.IGenericListener;
import org.eclipse.jubula.client.core.utils.ListenerManager;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataEventDispatcher
implements GeneralStorage.IReloadedSessionListener,
GeneralStorage.IDataModifiedListener {
    private static final Logger LOG = LoggerFactory.getLogger(DataEventDispatcher.class);
    private static DataEventDispatcher instance = null;
    private ListenerManager<IDialogStatusListener> m_dialogStatusListenerMgr = new ListenerManager();
    private Set<IDataChangedListener> m_dataChangedListeners = new HashSet<IDataChangedListener>();
    private Set<IDataChangedListener> m_dataChangedListenersPost = new HashSet<IDataChangedListener>();
    private Set<ILanguageChangedListener> m_langChangedListeners = new HashSet<ILanguageChangedListener>();
    private Set<ILanguageChangedListener> m_langChangedListenersPost = new HashSet<ILanguageChangedListener>();
    private Set<IPartClosedListener> m_partClosedListeners = new HashSet<IPartClosedListener>();
    private Set<IPartClosedListener> m_partClosedListenersPost = new HashSet<IPartClosedListener>();
    private Set<IPropertyChangedListener> m_propertyChangedListeners = new HashSet<IPropertyChangedListener>();
    private Set<IPropertyChangedListener> m_propertyChangedListenersPost = new HashSet<IPropertyChangedListener>();
    private Set<IParamChangedListener> m_paramChangedListeners = new HashSet<IParamChangedListener>();
    private Set<IParamChangedListener> m_paramChangedListenersPost = new HashSet<IParamChangedListener>();
    private Set<IProjectLoadedListener> m_projectLoadedListeners = new HashSet<IProjectLoadedListener>();
    private Set<IProjectLoadedListener> m_projectLoadedListenersPost = new HashSet<IProjectLoadedListener>();
    private Set<IServerConnectionListener> m_autAgentConnectionListener = new HashSet<IServerConnectionListener>();
    private Set<IServerConnectionListener> m_autAgentConnectionListenerPost = new HashSet<IServerConnectionListener>();
    private Set<IServerConnectionListener> m_autServerConnectionListeners = new HashSet<IServerConnectionListener>();
    private Set<IServerConnectionListener> m_autServerConnectionListenersPost = new HashSet<IServerConnectionListener>();
    private Set<IAutStateListener> m_autStateListeners = new HashSet<IAutStateListener>();
    private Set<IAutStateListener> m_autStateListenersPost = new HashSet<IAutStateListener>();
    private Set<ITestresultChangedListener> m_testresultListeners = new HashSet<ITestresultChangedListener>();
    private Set<ITestresultChangedListener> m_testresultListenersPost = new HashSet<ITestresultChangedListener>();
    private Set<ITestSuiteStateListener> m_testSuiteStateListeners = new HashSet<ITestSuiteStateListener>();
    private Set<ITestSuiteStateListener> m_testSuiteStateListenersPost = new HashSet<ITestSuiteStateListener>();
    private Set<IOMStateListener> m_omStateListeners = new HashSet<IOMStateListener>();
    private Set<IOMAUTListener> m_omAUTListeners = new HashSet<IOMAUTListener>();
    private Set<IOMWindowsListener> m_omWindowListeners = new HashSet<IOMWindowsListener>();
    private Set<ITestresultSummaryEventListener> m_testresultSummaryListener = new HashSet<ITestresultSummaryEventListener>();
    private Set<IOMStateListener> m_omStateListenersPost = new HashSet<IOMStateListener>();
    private Set<IRecordModeStateListener> m_recordModeStateListeners = new HashSet<IRecordModeStateListener>();
    private Set<IRecordModeStateListener> m_recordModeStateListenersPost = new HashSet<IRecordModeStateListener>();
    private Set<ICompletenessCheckListener> m_completenessCheckListeners = new HashSet<ICompletenessCheckListener>();
    private Set<IProblemPropagationListener> m_problemPropagationListeners = new HashSet<IProblemPropagationListener>();
    private Set<IProjectStateListener> m_projectStateListeners = new HashSet<IProjectStateListener>();

    private DataEventDispatcher() {
        GeneralStorage gs = GeneralStorage.getInstance();
        gs.addReloadedSessListener(this);
        gs.addDataModifiedListener(this);
    }

    public static synchronized DataEventDispatcher getInstance() {
        if (instance == null) {
            instance = new DataEventDispatcher();
        }
        return instance;
    }

    public void addDataChangedListener(IDataChangedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_dataChangedListenersPost.add(l);
        } else {
            this.m_dataChangedListeners.add(l);
        }
    }

    public void addLanguageChangedListener(ILanguageChangedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_langChangedListenersPost.add(l);
        } else {
            this.m_langChangedListeners.add(l);
        }
    }

    public void removeDataChangedListener(IDataChangedListener l) {
        this.m_dataChangedListeners.remove(l);
        this.m_dataChangedListenersPost.remove(l);
    }

    public void removeLanguageChangedListener(ILanguageChangedListener l) {
        this.m_langChangedListeners.remove(l);
        this.m_langChangedListenersPost.remove(l);
    }

    public void fireDataChangedListener(IPersistentObject po, DataState dataState, UpdateState updateState) {
        this.fireDataChangedListener(new DataChangedEvent(po, dataState, updateState));
    }

    public void fireDataChangedListener(DataChangedEvent ... events) {
        HashSet<IDataChangedListener> stableListeners = new HashSet<IDataChangedListener>(this.m_dataChangedListeners);
        for (IDataChangedListener l : stableListeners) {
            try {
                l.handleDataChanged(events);
            }
            catch (Throwable t) {
                if (t instanceof EntityNotFoundException) {
                    String msg = Messages.DataEventDispatcherReopenProject;
                    ErrorMessagePresenter.getPresenter().showErrorMessage(MessageIDs.E_PERSISTENCE_LOAD_FAILED, null, new String[]{msg});
                }
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IDataChangedListener> stableListenersPost = new HashSet<IDataChangedListener>(this.m_dataChangedListenersPost);
        for (IDataChangedListener l : stableListenersPost) {
            try {
                l.handleDataChanged(events);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addParamChangedListener(IParamChangedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_paramChangedListenersPost.add(l);
        } else {
            this.m_paramChangedListeners.add(l);
        }
    }

    public void removeParamChangedListener(IParamChangedListener l) {
        this.m_paramChangedListeners.remove(l);
        this.m_paramChangedListenersPost.remove(l);
    }

    public void fireParamChangedListener() {
        HashSet<IParamChangedListener> stableListeners = new HashSet<IParamChangedListener>(this.m_paramChangedListeners);
        for (IParamChangedListener l : stableListeners) {
            try {
                l.handleParamChanged();
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IParamChangedListener> stableListenersPost = new HashSet<IParamChangedListener>(this.m_paramChangedListenersPost);
        for (IParamChangedListener l : stableListenersPost) {
            try {
                l.handleParamChanged();
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void fireCompletenessCheckFinished() {
        for (ICompletenessCheckListener l : this.m_completenessCheckListeners) {
            l.completenessCheckFinished();
        }
    }

    public void fireProblemPropagationFinished() {
        for (IProblemPropagationListener l : this.m_problemPropagationListeners) {
            l.problemPropagationFinished();
        }
    }

    @Override
    public void reloadData(IProgressMonitor monitor) {
        this.fireProjectLoadedListener(monitor);
    }

    public void addPartClosedListener(IPartClosedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_partClosedListenersPost.add(l);
        } else {
            this.m_partClosedListeners.add(l);
        }
    }

    public void removePartClosedListener(IPartClosedListener l) {
        this.m_partClosedListeners.remove(l);
        this.m_partClosedListenersPost.remove(l);
    }

    public void addPropertyChangedListener(IPropertyChangedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_propertyChangedListenersPost.add(l);
        } else {
            this.m_propertyChangedListeners.add(l);
        }
    }

    public void removePropertyChangedListener(IPropertyChangedListener l) {
        this.m_propertyChangedListeners.remove(l);
        this.m_propertyChangedListenersPost.remove(l);
    }

    public void firePartClosed(IWorkbenchPart part) {
        HashSet<IPartClosedListener> stableListeners = new HashSet<IPartClosedListener>(this.m_partClosedListeners);
        for (IPartClosedListener l : stableListeners) {
            try {
                l.handlePartClosed(part);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IPartClosedListener> stableListenersPost = new HashSet<IPartClosedListener>(this.m_partClosedListenersPost);
        for (IPartClosedListener l : stableListenersPost) {
            try {
                l.handlePartClosed(part);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void firePropertyChanged(boolean isCompNameChanged) {
        HashSet<IPropertyChangedListener> stableListeners = new HashSet<IPropertyChangedListener>(this.m_propertyChangedListeners);
        for (IPropertyChangedListener l : stableListeners) {
            try {
                l.handlePropertyChanged(isCompNameChanged);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IPropertyChangedListener> stableListenersPost = new HashSet<IPropertyChangedListener>(this.m_propertyChangedListenersPost);
        for (IPropertyChangedListener l : stableListenersPost) {
            try {
                l.handlePropertyChanged(isCompNameChanged);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void fireLanguageChanged(Locale locale) {
        HashSet<ILanguageChangedListener> langChangedListeners = new HashSet<ILanguageChangedListener>(this.m_langChangedListeners);
        for (ILanguageChangedListener l : langChangedListeners) {
            try {
                l.handleLanguageChanged(locale);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<ILanguageChangedListener> stableListenersPost = new HashSet<ILanguageChangedListener>(this.m_langChangedListenersPost);
        for (ILanguageChangedListener l : stableListenersPost) {
            try {
                l.handleLanguageChanged(locale);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addProjectLoadedListener(IProjectLoadedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_projectLoadedListenersPost.add(l);
        } else {
            this.m_projectLoadedListeners.add(l);
        }
    }

    public void removeProjectLoadedListener(IProjectLoadedListener l) {
        this.m_projectLoadedListeners.remove(l);
        this.m_projectLoadedListenersPost.remove(l);
    }

    public void fireProjectLoadedListener(IProgressMonitor monitor) {
        new LoadProjectDataOperation().run(monitor);
    }

    public void addAutAgentConnectionListener(IServerConnectionListener l, boolean guiMode) {
        if (guiMode) {
            this.m_autAgentConnectionListenerPost.add(l);
        } else {
            this.m_autAgentConnectionListener.add(l);
        }
    }

    public void removeAutAgentConnectionListener(IServerConnectionListener l) {
        this.m_autAgentConnectionListener.remove(l);
        this.m_autAgentConnectionListenerPost.remove(l);
    }

    public void fireAutAgentConnectionChanged(ServerState state) {
        HashSet<IServerConnectionListener> stableListeners = new HashSet<IServerConnectionListener>(this.m_autAgentConnectionListener);
        for (IServerConnectionListener l : stableListeners) {
            try {
                l.handleServerConnStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IServerConnectionListener> stableListenersPost = new HashSet<IServerConnectionListener>(this.m_autAgentConnectionListenerPost);
        for (IServerConnectionListener l : stableListenersPost) {
            try {
                l.handleServerConnStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addAutServerConnectionListener(IServerConnectionListener l, boolean guiMode) {
        if (guiMode) {
            this.m_autServerConnectionListenersPost.add(l);
        } else {
            this.m_autServerConnectionListeners.add(l);
        }
    }

    public void removeAutServerConnectionListener(IServerConnectionListener l) {
        this.m_autServerConnectionListeners.remove(l);
        this.m_autServerConnectionListenersPost.remove(l);
    }

    public void fireAutServerConnectionChanged(ServerState state) {
        HashSet<IServerConnectionListener> stableListeners = new HashSet<IServerConnectionListener>(this.m_autServerConnectionListeners);
        for (IServerConnectionListener l : stableListeners) {
            try {
                l.handleServerConnStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IServerConnectionListener> stableListenersPost = new HashSet<IServerConnectionListener>(this.m_autServerConnectionListenersPost);
        for (IServerConnectionListener l : stableListenersPost) {
            try {
                l.handleServerConnStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addRecordModeStateListener(IRecordModeStateListener l, boolean guiMode) {
        if (guiMode) {
            this.m_recordModeStateListenersPost.add(l);
        } else {
            this.m_recordModeStateListeners.add(l);
        }
    }

    public void removeRecordModeStateListener(IRecordModeStateListener l) {
        this.m_recordModeStateListeners.remove(l);
        this.m_recordModeStateListenersPost.remove(l);
    }

    public boolean addCompletenessCheckListener(ICompletenessCheckListener l) {
        return this.m_completenessCheckListeners.add(l);
    }

    public boolean removeCompletenessCheckListener(ICompletenessCheckListener l) {
        return this.m_completenessCheckListeners.remove(l);
    }

    public boolean addProblemPropagationListener(IProblemPropagationListener l) {
        return this.m_problemPropagationListeners.add(l);
    }

    public boolean removeProblemPropagationListener(IProblemPropagationListener l) {
        return this.m_problemPropagationListeners.remove(l);
    }

    public void fireRecordModeStateChanged(RecordModeState state) {
        HashSet<IRecordModeStateListener> stableListeners = new HashSet<IRecordModeStateListener>(this.m_recordModeStateListeners);
        for (IRecordModeStateListener l : stableListeners) {
            try {
                l.handleRecordModeStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IRecordModeStateListener> stableListenersPost = new HashSet<IRecordModeStateListener>(this.m_recordModeStateListenersPost);
        for (IRecordModeStateListener l : stableListenersPost) {
            try {
                l.handleRecordModeStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addOMStateListener(IOMStateListener l, boolean guiMode) {
        if (guiMode) {
            this.m_omStateListenersPost.add(l);
        } else {
            this.m_omStateListeners.add(l);
        }
    }

    public void removeOMStateListener(IOMStateListener l) {
        this.m_omStateListeners.remove(l);
        this.m_omStateListenersPost.remove(l);
    }

    public void fireOMStateChanged(OMState state) {
        HashSet<IOMStateListener> stableListeners = new HashSet<IOMStateListener>(this.m_omStateListeners);
        for (IOMStateListener l : stableListeners) {
            try {
                l.handleOMStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IOMStateListener> stableListenersPost = new HashSet<IOMStateListener>(this.m_omStateListenersPost);
        for (IOMStateListener l : stableListenersPost) {
            try {
                l.handleOMStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addAutStateListener(IAutStateListener l, boolean guiMode) {
        if (guiMode) {
            this.m_autStateListenersPost.add(l);
        } else {
            this.m_autStateListeners.add(l);
        }
    }

    public void removeAutStateListener(IAutStateListener l) {
        this.m_autStateListeners.remove(l);
        this.m_autStateListenersPost.remove(l);
    }

    public void fireAutStateChanged(AutState state) {
        HashSet<IAutStateListener> stableListeners = new HashSet<IAutStateListener>(this.m_autStateListeners);
        for (IAutStateListener l : stableListeners) {
            try {
                l.handleAutStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<IAutStateListener> stableListenersPost = new HashSet<IAutStateListener>(this.m_autStateListenersPost);
        for (IAutStateListener l : stableListenersPost) {
            try {
                l.handleAutStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addTestresultListener(ITestresultChangedListener l, boolean guiMode) {
        if (guiMode) {
            this.m_testresultListenersPost.add(l);
        } else {
            this.m_testresultListeners.add(l);
        }
    }

    public void removeTestresultListener(ITestresultChangedListener l) {
        this.m_testresultListeners.remove(l);
        this.m_testresultListenersPost.remove(l);
    }

    public void fireTestresultChanged(TestresultState state) {
        HashSet<ITestresultChangedListener> stableListeners = new HashSet<ITestresultChangedListener>(this.m_testresultListeners);
        for (ITestresultChangedListener l : stableListeners) {
            try {
                l.handleTestresultChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<ITestresultChangedListener> stableListenersPost = new HashSet<ITestresultChangedListener>(this.m_testresultListenersPost);
        for (ITestresultChangedListener l : stableListenersPost) {
            try {
                l.handleTestresultChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addTestSuiteStateListener(ITestSuiteStateListener l, boolean guiMode) {
        if (guiMode) {
            this.m_testSuiteStateListenersPost.add(l);
        } else {
            this.m_testSuiteStateListeners.add(l);
        }
    }

    public void removeTestSuiteStateListener(ITestSuiteStateListener l) {
        this.m_testSuiteStateListeners.remove(l);
        this.m_testSuiteStateListenersPost.remove(l);
    }

    public void fireTestSuiteStateChanged(TestExecutionEvent event) {
        HashSet<ITestSuiteStateListener> stableListeners = new HashSet<ITestSuiteStateListener>(this.m_testSuiteStateListeners);
        for (ITestSuiteStateListener l : stableListeners) {
            try {
                l.handleTSStateChanged(event);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
        HashSet<ITestSuiteStateListener> stableListenersPost = new HashSet<ITestSuiteStateListener>(this.m_testSuiteStateListenersPost);
        for (ITestSuiteStateListener l : stableListenersPost) {
            try {
                l.handleTSStateChanged(event);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void fireProjectStateChanged(ProjectState state) {
        HashSet<IProjectStateListener> projectStateListeners = new HashSet<IProjectStateListener>(this.m_projectStateListeners);
        for (IProjectStateListener l : projectStateListeners) {
            try {
                l.handleProjectStateChanged(state);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addProjectStateListener(IProjectStateListener l) {
        this.m_projectStateListeners.add(l);
    }

    public void removeProjectStateListener(IProjectStateListener l) {
        this.m_projectStateListeners.remove(l);
    }

    @Override
    public void dataModified(IPersistentObject po) {
        this.fireDataChangedListener(new DataChangedEvent(po, DataState.StructureModified, UpdateState.all));
    }

    public ListenerManager<IDialogStatusListener> getDialogStatusListenerMgr() {
        return this.m_dialogStatusListenerMgr;
    }

    public void fireOMAutChanged(AutIdentifier identifier) {
        HashSet<IOMAUTListener> stableListeners = new HashSet<IOMAUTListener>(this.m_omAUTListeners);
        for (IOMAUTListener l : stableListeners) {
            try {
                l.handleAUTChanged(identifier);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addOMAUTListener(IOMAUTListener l, boolean guiMode) {
        if (guiMode) {
            this.m_omAUTListeners.add(l);
        } else {
            this.m_omAUTListeners.add(l);
        }
    }

    public void removeOMAUTListener(IOMAUTListener l) {
        this.m_omAUTListeners.remove(l);
    }

    public void fireWindowsChanged(String[] windowTitles) {
        HashSet<IOMWindowsListener> stableListeners = new HashSet<IOMWindowsListener>(this.m_omWindowListeners);
        for (IOMWindowsListener l : stableListeners) {
            try {
                l.handleAUTChanged(windowTitles);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
            }
        }
    }

    public void addAUTWindowsListener(IOMWindowsListener l, boolean guiMode) {
        if (guiMode) {
            this.m_omWindowListeners.add(l);
        } else {
            this.m_omWindowListeners.add(l);
        }
    }

    public void removeAUTWindowsListener(IOMWindowsListener l) {
        this.m_omWindowListeners.remove(l);
    }

    public void fireTestresultSummaryChanged(ITestResultSummaryPO summary, DataState state) {
        HashSet<ITestresultSummaryEventListener> notifySet = new HashSet<ITestresultSummaryEventListener>(this.m_testresultSummaryListener);
        for (ITestresultSummaryEventListener l : notifySet) {
            l.handleTestresultSummaryChanged(summary, state);
        }
    }

    public void addTestresultSummaryEventListener(ITestresultSummaryEventListener listener) {
        this.m_testresultSummaryListener.add(listener);
    }

    public void removeTestresultSummaryEventListener(ITestresultSummaryEventListener listener) {
        this.m_testresultSummaryListener.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutState {
        running,
        notRunning;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataState {
        Renamed,
        Added,
        Deleted,
        StructureModified,
        ReuseChanged;

    }

    public static interface IAutStateListener {
        public void handleAutStateChanged(AutState var1);
    }

    public static interface ICompletenessCheckListener {
        public void completenessCheckFinished();
    }

    public static interface IDataChangedListener {
        public void handleDataChanged(DataChangedEvent ... var1);
    }

    public static interface IDialogStatusListener
    extends IGenericListener {
    }

    public static interface ILanguageChangedListener {
        public void handleLanguageChanged(Locale var1);
    }

    public static interface IOMAUTListener {
        public void handleAUTChanged(AutIdentifier var1);
    }

    public static interface IOMStateListener {
        public void handleOMStateChanged(OMState var1);
    }

    public static interface IOMWindowsListener {
        public void handleAUTChanged(String[] var1);
    }

    public static interface IParamChangedListener {
        public void handleParamChanged();
    }

    public static interface IPartClosedListener {
        public void handlePartClosed(IWorkbenchPart var1);
    }

    public static interface IProblemPropagationListener {
        public void problemPropagationFinished();
    }

    public static interface IProjectLoadedListener {
        public void handleProjectLoaded();
    }

    public static interface IProjectStateListener {
        public void handleProjectStateChanged(ProjectState var1);
    }

    public static interface IPropertyChangedListener {
        public void handlePropertyChanged(boolean var1);
    }

    public static interface IRecordModeStateListener {
        public void handleRecordModeStateChanged(RecordModeState var1);
    }

    public static interface IServerConnectionListener {
        public void handleServerConnStateChanged(ServerState var1);
    }

    public static interface ITestSuiteStateListener {
        public void handleTSStateChanged(TestExecutionEvent var1);
    }

    public static interface ITestresultChangedListener {
        public void handleTestresultChanged(TestresultState var1);
    }

    public static interface ITestresultSummaryEventListener
    extends EventListener {
        public void handleTestresultSummaryChanged(ITestResultSummaryPO var1, DataState var2);
    }

    public class LoadProjectDataOperation
    implements IRunnableWithProgress {
        public void run(IProgressMonitor monitor) {
            HashSet stableListeners = new HashSet(DataEventDispatcher.this.m_projectLoadedListeners);
            for (IProjectLoadedListener l : stableListeners) {
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    l.handleProjectLoaded();
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (NestableRuntimeException nre) {
                    Throwable rootCause = nre.getThrowable(nre.getThrowableCount() - 1);
                    if (rootCause instanceof OperationCanceledException) continue;
                    LOG.error(Messages.UnhandledExceptionWhileCallListeners, (Throwable)nre);
                }
                catch (Throwable t) {
                    LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
                }
            }
            HashSet stableListenersPost = new HashSet(DataEventDispatcher.this.m_projectLoadedListenersPost);
            for (IProjectLoadedListener l : stableListenersPost) {
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    l.handleProjectLoaded();
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (NestableRuntimeException nre) {
                    Throwable rootCause = nre.getThrowable(nre.getThrowableCount() - 1);
                    if (rootCause instanceof OperationCanceledException) continue;
                    LOG.error(Messages.UnhandledExceptionWhileCallListeners, (Throwable)nre);
                }
                catch (Throwable t) {
                    LOG.error(Messages.UnhandledExceptionWhileCallListeners, t);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OMState {
        running,
        notRunning;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectState {
        opened,
        prop_modified,
        closed;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordModeState {
        running,
        notRunning;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerState {
        Connected,
        Disconnected,
        Connecting;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestresultState {
        Clear,
        Refresh;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateState {
        onlyInEditor,
        notInEditor,
        all;

    }
}

