/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.CompIdentifierPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.ObjectMappingCategoryPO;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="OM_ASSOC")
public class ObjectMappingAssoziationPO
implements IObjectMappingAssoziationPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id = null;
    private Long m_parentProjectId = null;
    private String m_type = null;
    private transient Integer m_version;
    private ICompIdentifierPO m_technicalName = null;
    private IObjectMappingCategoryPO m_category = null;
    private List<String> m_logicalNames = new LinkedList<String>();
    private transient IComponentIdentifier m_compIdentifier = null;
    static final long serialVersionUID = -2710520314196510311L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    ObjectMappingAssoziationPO() {
    }

    ObjectMappingAssoziationPO(IComponentIdentifier tech) {
        this.setCompIdentifier(tech);
        if (tech != null) {
            ICompIdentifierPO techNamePO = this.createCompIdPoObject(tech);
            this.setTechnicalName(techNamePO);
            if (techNamePO != null) {
                techNamePO.setParentProjectId(this.getParentProjectId());
            }
        }
    }

    ObjectMappingAssoziationPO(IComponentIdentifier tec, List<String> logic) {
        this(tec);
        this.setLogicalNames(logic);
    }

    ObjectMappingAssoziationPO(IComponentIdentifier tec, String logic) {
        this(tec);
        Assert.verify((logic != null ? 1 : 0) != 0);
        this.getLogicalNames().add(logic);
    }

    @Override
    @Basic
    @Column(length=4000)
    public String getType() {
        return this.m_type;
    }

    @Override
    public void setType(String type) {
        this.m_type = type;
    }

    @Override
    public void setLogicalNames(List<String> logicalNames) {
        this.m_logicalNames = logicalNames;
    }

    @Override
    public void addLogicalName(String name) {
        if (name != null && !this.getLogicalNames().contains(name)) {
            this.getLogicalNames().add(name);
        }
    }

    @Override
    public void removeLogicalName(String name) {
        if (name != null) {
            this.getLogicalNames().remove(name);
        }
    }

    @Override
    @OneToOne(cascade={CascadeType.ALL}, targetEntity=CompIdentifierPO.class, fetch=FetchType.EAGER)
    @BatchFetch(value=BatchFetchType.JOIN)
    public ICompIdentifierPO getTechnicalName() {
        return this.m_technicalName;
    }

    @Override
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="LOGICAL_NAME")
    @JoinColumn(name="OM_ASSOC")
    @OrderColumn(name="IDX")
    @Column(name="LOGICAL_NAME", length=4000)
    @BatchFetch(value=BatchFetchType.JOIN)
    public List<String> getLogicalNames() {
        return this.m_logicalNames;
    }

    @Override
    public void setTechnicalName(ICompIdentifierPO technicalName) {
        this.m_technicalName = technicalName;
    }

    @Override
    @Transient
    public IObjectMappingCategoryPO getCategory() {
        return this.getHbmCategory();
    }

    @Override
    public void setCategory(IObjectMappingCategoryPO category) {
        this.setHbmCategory(category);
    }

    @ManyToOne(targetEntity=ObjectMappingCategoryPO.class)
    @JoinColumn(name="FK_CATEGORY", insertable=false, updatable=false)
    public IObjectMappingCategoryPO getHbmCategory() {
        return this.m_category;
    }

    private void setHbmCategory(IObjectMappingCategoryPO category) {
        this.m_category = category;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        if (this.getTechnicalName() != null) {
            this.m_technicalName.setParentProjectId(projectId);
        }
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    private ICompIdentifierPO createCompIdPoObject(IComponentIdentifier tech) {
        CompIdentifierPO techNamePO = new CompIdentifierPO();
        techNamePO.setComponentClassName(tech.getComponentClassName());
        techNamePO.setHierarchyNames(tech.getHierarchyNames());
        techNamePO.setNeighbours(tech.getNeighbours());
        techNamePO.setSupportedClassName(tech.getSupportedClassName());
        techNamePO.setAlternativeDisplayName(tech.getAlternativeDisplayName());
        return techNamePO;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return this.toString();
    }

    @Override
    public void changeCompName(String oldCompNameGuid, String newCompNameGuid) {
        this.removeLogicalName(oldCompNameGuid);
        this.addLogicalName(newCompNameGuid);
    }

    @Override
    public String getComponentType(IWritableComponentNameCache compNameCache, Collection<Component> availableComponents) {
        String supportedClassName;
        ICompIdentifierPO techName = this.getTechnicalName();
        if (techName != null && (supportedClassName = this.getTechnicalName().getSupportedClassName()) != null) {
            return CompSystem.getComponentType((String)supportedClassName, availableComponents);
        }
        return null;
    }

    @Override
    @Transient
    public IObjectMappingCategoryPO getSection() {
        IObjectMappingCategoryPO category = this.getCategory();
        IObjectMappingCategoryPO section = null;
        if (category != null) {
            section = category.getSection();
        }
        return section;
    }

    @Override
    public void setCompIdentifier(IComponentIdentifier compIdentifier) {
        this.m_compIdentifier = compIdentifier;
    }

    @Override
    @Transient
    public IComponentIdentifier getCompIdentifier() {
        return this.m_compIdentifier;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ObjectMappingAssoziationPO();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmCategory") {
            return this.hbmCategory;
        }
        if (string == "technicalName") {
            return this.technicalName;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "logicalNames") {
            return this.logicalNames;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmCategory") {
            this.hbmCategory = (IObjectMappingCategoryPO)object;
            return;
        }
        if (string == "technicalName") {
            this.technicalName = (ICompIdentifierPO)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "logicalNames") {
            this.logicalNames = (List)object;
            return;
        }
        if (string == "type") {
            this.type = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

