/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventHandlerContainer;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AddEventHandlerDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int VERTICAL_SPACING = 10;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private int m_maxLength = 255;
    private Composite m_area = null;
    private Text m_refNameField;
    private Combo m_eventTypesCombo;
    private Combo m_reentryTypesCombo;
    private final IEventHandlerContainer m_eventHandlerContainer;
    private Label m_maxRetriesLabel;
    private Spinner m_maxRetriesText;
    private List<Listener> m_listenerList = new ArrayList<Listener>();
    private String m_tcName;

    public AddEventHandlerDialog(Shell parentShell, String tcName, IEventHandlerContainer eventTc) {
        super(parentShell);
        this.m_eventHandlerContainer = eventTc;
        this.m_tcName = tcName;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        this.getButton(0).setEnabled(false);
        return button;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AddEventHandlerDialogAddErrorHandler);
        this.setTitleImage(IconConstants.NEW_EH_DIALOG_IMAGE);
        this.getShell().setText(Messages.AddEventHandlerDialogAddErrorHandler);
        this.setMessage(Messages.AddEventHandlerDialogMessage);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 10;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        this.m_area = new Composite(parent, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.m_area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        this.m_area.setLayoutData((Object)gridData);
        new Label(this.m_area, 0).setLayoutData((Object)this.newGridData(2));
        this.createWidgets(this.m_area);
        new Label(this.m_area, 0).setLayoutData((Object)this.newGridData(2));
        LayoutUtil.createSeparator((Composite)parent);
        this.addListenerToWidgets();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.eventHandlerAddContextId");
        this.setHelpAvailable(true);
        return this.m_area;
    }

    private void createWidgets(Composite parent) {
        Label eventNameLabel = new Label(parent, 0);
        eventNameLabel.setText(Messages.AddEventHandlerDialogLabel);
        Text nameText = new Text(parent, 2052);
        GridData eventNameGridData = new GridData(4, 0, true, false);
        nameText.setLayoutData((Object)eventNameGridData);
        nameText.setText(this.m_tcName);
        nameText.setEnabled(false);
        Label eventRefNameLabel = new Label(parent, 0);
        eventRefNameLabel.setText(Messages.AddEventHandlerDialogRefNameLabel);
        this.m_refNameField = new Text(parent, 2052);
        GridData eventRefNameGridData = new GridData(4, 0, true, false);
        this.m_refNameField.setLayoutData((Object)eventRefNameGridData);
        this.m_refNameField.setTextLimit(this.m_maxLength);
        Collection eventTcList = this.m_eventHandlerContainer.getAllEventEventExecTC();
        ArrayList<String> existentEventTypes = new ArrayList<String>();
        for (IEventExecTestCasePO eventTc : eventTcList) {
            existentEventTypes.add(eventTc.getEventType());
        }
        Label eventTypeLabel = new Label(parent, 0);
        eventTypeLabel.setText(Messages.AddEventHandlerDialogEventType);
        this.m_eventTypesCombo = new Combo(parent, 12);
        GridData eventGridData = new GridData(4, 0, true, false);
        this.m_eventTypesCombo.setLayoutData((Object)eventGridData);
        Set mapKeySet = ComponentBuilder.getInstance().getCompSystem().getEventTypes().keySet();
        ArrayList<String> selectableEventTypes = new ArrayList<String>();
        Map stringHelperMap = StringHelper.getInstance().getMap();
        for (String eventTypeKey : mapKeySet) {
            if (existentEventTypes.contains(eventTypeKey)) continue;
            selectableEventTypes.add((String)stringHelperMap.get(eventTypeKey));
        }
        this.m_eventTypesCombo.setItems(selectableEventTypes.toArray(new String[selectableEventTypes.size()]));
        Label reentryTypeLabel = new Label(parent, 0);
        reentryTypeLabel.setText(Messages.AddEventHandlerDialogReentryType);
        this.m_reentryTypesCombo = new Combo(parent, 12);
        GridData reentryGridData = new GridData(4, 0, true, false);
        this.m_reentryTypesCombo.setLayoutData((Object)reentryGridData);
        ReentryProperty[] reentryProps = ReentryProperty.REENTRY_PROP_ARRAY;
        String[] reentryStrings = new String[reentryProps.length];
        int k = 0;
        while (k < reentryProps.length) {
            reentryStrings[k] = reentryProps[k].toString();
            ++k;
        }
        this.m_reentryTypesCombo.setItems(reentryStrings);
        SelectionListener reentryComboListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddEventHandlerDialog.this.setMaxRetriesVisibility();
            }
        };
        this.m_reentryTypesCombo.addSelectionListener(reentryComboListener);
        this.createMaxNumRetriesWidgets(parent);
    }

    private void createMaxNumRetriesWidgets(Composite parent) {
        this.m_maxRetriesLabel = new Label(parent, 0);
        this.m_maxRetriesLabel.setText(Messages.AddEventHandlerDialogMaxNumRetries);
        this.m_maxRetriesText = new Spinner(parent, 2052);
        this.m_maxRetriesText.setSelection(1);
        this.m_maxRetriesText.setMinimum(1);
        this.m_maxRetriesText.setMaximum(Integer.MAX_VALUE);
        GridData maxRetriesGridData = new GridData(4, 0, true, false);
        this.m_maxRetriesText.setLayoutData((Object)maxRetriesGridData);
        this.setMaxRetriesVisibility();
    }

    private GridData newGridData(int horizontalSpan) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = horizontalSpan;
        return gridData;
    }

    public void addListener(Listener listener) {
        if (!this.m_listenerList.contains(listener)) {
            this.m_listenerList.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.m_listenerList.remove(listener);
    }

    private void notifyListener() {
        Iterator<Listener> iter = this.m_listenerList.iterator();
        while (iter.hasNext()) {
            iter.next().notifySelected(this.m_refNameField.getText(), this.m_eventTypesCombo.getText(), this.m_reentryTypesCombo.getText(), this.m_maxRetriesText.isVisible() ? Integer.valueOf(this.m_maxRetriesText.getSelection()) : null);
        }
    }

    protected void okPressed() {
        this.notifyListener();
        super.okPressed();
    }

    private boolean checkRefNameFieldAction() {
        int nameLength = this.m_refNameField.getText().length();
        if (nameLength > 0) {
            if (nameLength >= this.m_maxLength) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.W_MAX_CHAR, (Object[])new Object[]{this.m_maxLength}, null);
                this.setErrorMessage(Messages.AddEventHandlerDialogIncorrectRefNameInput);
                return false;
            }
            String refName = this.m_refNameField.getText();
            if (refName.startsWith(" ") || refName.endsWith(" ")) {
                this.setErrorMessage(Messages.AddEventHandlerDialogIncorrectRefNameInput);
                return false;
            }
        }
        return true;
    }

    private boolean checkEventTypeComboAction() {
        if (this.m_eventTypesCombo.getText() == "") {
            this.setErrorMessage(Messages.AddEventHandlerDialogNoEventTypeSel);
            return false;
        }
        return true;
    }

    private boolean checkReentryTypeComboAction() {
        if (this.m_reentryTypesCombo.getText() == "") {
            this.setErrorMessage(Messages.AddEventHandlerDialogNoReentryTypeSel);
            return false;
        }
        return true;
    }

    private void enableOKButton(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
        if (enabled) {
            this.setErrorMessage(null);
        }
    }

    public boolean close() {
        this.m_listenerList.clear();
        return super.close();
    }

    private void addListenerToWidgets() {
        WidgetModifyListener listener = new WidgetModifyListener();
        this.m_eventTypesCombo.addModifyListener((ModifyListener)listener);
        this.m_reentryTypesCombo.addModifyListener((ModifyListener)listener);
        this.m_refNameField.addModifyListener((ModifyListener)listener);
    }

    private void setMaxRetriesVisibility() {
        boolean isRetryReentrySelected = this.m_reentryTypesCombo.getSelectionIndex() != -1 && ReentryProperty.REENTRY_PROP_ARRAY[this.m_reentryTypesCombo.getSelectionIndex()].equals((Object)ReentryProperty.RETRY);
        this.m_maxRetriesLabel.setVisible(isRetryReentrySelected);
        this.m_maxRetriesText.setVisible(isRetryReentrySelected);
        this.m_maxRetriesLabel.getParent().layout();
    }

    private boolean dialogInputIsValid() {
        return this.checkRefNameFieldAction() && this.checkReentryTypeComboAction() && this.checkEventTypeComboAction();
    }

    public static abstract class Listener {
        public abstract void notifySelected(String var1, String var2, String var3, Integer var4);
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            AddEventHandlerDialog.this.enableOKButton(AddEventHandlerDialog.this.dialogInputIsValid());
        }
    }
}

