/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import java.util.Collection;
import java.util.List;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.propertytester.AbstractBooleanPropertyTester;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMappingCollectionPropertyTester
extends AbstractBooleanPropertyTester {
    public static final String IS_PASTE_ALLOWED = "isPasteAllowed";
    private static final String[] PROPERTIES = new String[]{"isPasteAllowed"};

    public boolean testImpl(Object receiver, String property, Object[] args) {
        Collection selectionContents = (Collection)receiver;
        if (property.equals(IS_PASTE_ALLOWED)) {
            return this.testIsPasteAllowed(selectionContents);
        }
        return false;
    }

    private boolean testIsPasteAllowed(Collection<? extends Object> selectionContents) {
        LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof ObjectMappingMultiPageEditor)) {
            return false;
        }
        ObjectMappingMultiPageEditor objectMappingEditor = (ObjectMappingMultiPageEditor)activeEditor;
        Object cbContents = objectMappingEditor.getEditorHelper().getClipboard().getContents((Transfer)transfer);
        if (cbContents == null) {
            return false;
        }
        if (transfer.getSource() != null && !transfer.getSource().equals(objectMappingEditor.getTreeViewer())) {
            return false;
        }
        boolean isEnabled = false;
        isEnabled = transfer.containsOnlyType(IObjectMappingAssoziationPO.class) ? this.getPasteActionEnablementForAssocs(transfer.getSelection().toList(), selectionContents, objectMappingEditor) : (transfer.containsOnlyType(IObjectMappingCategoryPO.class) ? false : (transfer.containsOnlyType(IComponentNamePO.class) ? this.getPasteActionEnablementForCompNames(selectionContents, objectMappingEditor) : false));
        return isEnabled;
    }

    private boolean getPasteActionEnablementForCompNames(Collection<? extends Object> targetList, ObjectMappingMultiPageEditor objectMappingEditor) {
        for (Object object : targetList) {
            if (object instanceof IObjectMappingAssoziationPO) {
                return true;
            }
            if (object instanceof IObjectMappingCategoryPO) {
                if (OMEditorDndSupport.canMoveCompNames((IObjectMappingCategoryPO)object, objectMappingEditor)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForAssocs(List<IObjectMappingAssoziationPO> toMove, Collection<? extends Object> targetList, ObjectMappingMultiPageEditor objectMappingEditor) {
        for (Object object : targetList) {
            if (object instanceof IObjectMappingCategoryPO) {
                if (OMEditorDndSupport.canMoveAssociations(toMove, (IObjectMappingCategoryPO)object, objectMappingEditor)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public Class<? extends Object> getType() {
        return Collection.class;
    }

    public String[] getProperties() {
        return PROPERTIES;
    }
}

