/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.DependencyFinderOp;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.filter.JBPatternFilter;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.TestCaseTreeCompositeContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.rcp.sorter.NodeNameViewerSorter;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseTreeComposite
extends Composite {
    private static final int WIDTH_HINT = 300;
    private TreeViewer m_treeViewer;
    private INodePO m_setOfParentTestCase;
    private Set<INodePO> m_parentTestCases;
    private Set<INodePO> m_circDependList = new HashSet<INodePO>();

    public TestCaseTreeComposite(Composite parent, int treeStyle, Set<INodePO> parentTestCases) {
        this(parent, treeStyle);
        this.m_parentTestCases = parentTestCases;
        this.initTreeViewer();
    }

    private TestCaseTreeComposite(Composite parent, int treeStyle) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.setLayoutData(gridData);
        JBFilteredTree ft = new JBFilteredTree(this, treeStyle, (PatternFilter)new JBPatternFilter(), true);
        this.m_treeViewer = ft.getViewer();
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.heightHint = 300;
        LayoutUtil.addToolTipAndMaxWidth((GridData)layoutData, (Control)this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setLayoutData((Object)layoutData);
    }

    public TestCaseTreeComposite(Composite parent, int treeStyle, INodePO parentTestCase) {
        this(parent, treeStyle);
        this.m_setOfParentTestCase = parentTestCase;
        this.initTreeViewer();
    }

    private void initTreeViewer() {
        this.m_treeViewer.setUseHashlookup(true);
        this.getInitialInput();
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.m_treeViewer.setContentProvider((IContentProvider)new TestCaseTreeCompositeContentProvider());
        this.m_treeViewer.setInput((Object)GeneralStorage.getInstance().getProject());
        this.m_treeViewer.setSorter((ViewerSorter)new NodeNameViewerSorter());
    }

    private void getInitialInput() {
        if (this.m_parentTestCases != null) {
            for (ISpecTestCasePO iSpecTestCasePO : this.m_parentTestCases) {
                DependencyFinderOp op = new DependencyFinderOp((INodePO)iSpecTestCasePO);
                TreeTraverser traverser = new TreeTraverser((INodePO)GeneralStorage.getInstance().getProject(), (ITreeNodeOperation)op, true);
                traverser.traverse(true);
                if (this.m_circDependList == null) {
                    this.m_circDependList = op.getDependentNodes();
                    continue;
                }
                this.m_circDependList.addAll(op.getDependentNodes());
            }
        } else if (this.m_setOfParentTestCase != null) {
            DependencyFinderOp op = new DependencyFinderOp(this.m_setOfParentTestCase);
            TreeTraverser treeTraverser = new TreeTraverser((INodePO)GeneralStorage.getInstance().getProject(), (ITreeNodeOperation)op, true);
            treeTraverser.traverse(true);
            this.m_circDependList = op.getDependentNodes();
        }
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public boolean hasValidSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObj = objectArray[n2];
            if (this.m_circDependList.contains(selectedObj) || selectedObj instanceof ICategoryPO || selectedObj instanceof IReusedProjectPO) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private class LabelProvider
    implements IColorProvider,
    ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ISpecTestCasePO) {
                if (TestCaseTreeComposite.this.m_circDependList.contains(element)) {
                    return Plugin.TC_DISABLED_IMAGE;
                }
                return IconConstants.TC_IMAGE;
            }
            if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
                return IconConstants.CATEGORY_IMAGE;
            }
            return null;
        }

        public String getText(Object element) {
            return GeneralLabelProvider.getTextImpl(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getForeground(Object element) {
            if (element instanceof ISpecTestCasePO) {
                if (TestCaseTreeComposite.this.m_circDependList.contains(element)) {
                    return LayoutUtil.GRAY_COLOR;
                }
                return LayoutUtil.DEFAULT_OS_COLOR;
            }
            if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
                return LayoutUtil.GRAY_COLOR;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

