/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.I18nEnumCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFXAutConfigComponent
extends AutConfigComponent {
    public static final String AUT_CONFIG_DIALOG_MODE_KEY_DEFAULT = AutConfigComponent.Mode.BASIC.name();
    private static boolean isExecFieldEmpty = true;
    private static String executablePath;
    private boolean m_isExecFieldValid = true;
    private Text m_execTextField;
    private Button m_execButton;
    private Text m_autArgsTextField;
    private I18nEnumCombo<IAUTConfigPO.ActivationMethod> m_activationMethodCombo;
    private Text m_envTextArea;
    private WidgetModifyListener m_modifyListener;
    private WidgetFocusListener m_focusListener;
    private WidgetSelectionListener m_selectionListener;

    public JavaFXAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName, true);
    }

    public static boolean isExecFieldEmpty() {
        return isExecFieldEmpty;
    }

    @Override
    protected void createBasicArea(Composite basicAreaComposite) {
        super.createBasicArea(basicAreaComposite);
        this.initGUIAutConfigSettings(basicAreaComposite);
    }

    private void initGUIAutConfigSettings(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.exec");
        this.m_execTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_execTextField, (int)4000);
        this.m_execButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_execButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_execButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_execButton.setEnabled(Utils.isLocalhost());
    }

    @Override
    protected boolean putConfigValue(String key, String value) {
        boolean hasChanged = super.putConfigValue(key, value);
        if (hasChanged) {
            this.m_execTextField.setEnabled(true);
            this.m_execButton.setEnabled(this.checkLocalhostServer() || this.isRemoteRequest());
        }
        return hasChanged;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.m_activationMethodCombo.addSelectionListener((SelectionListener)selectionListener);
        this.m_envTextArea.addModifyListener((ModifyListener)modifyListener);
        this.getServerCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_execTextField.addFocusListener((FocusListener)this.getFocusListener());
        this.m_execTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_execButton.addSelectionListener((SelectionListener)selectionListener);
    }

    @Override
    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.m_activationMethodCombo.removeSelectionListener((SelectionListener)selectionListener);
        this.m_envTextArea.removeModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.removeModifyListener((ModifyListener)modifyListener);
        this.getServerCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_execTextField.removeFocusListener((FocusListener)this.getFocusListener());
        this.m_execTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_execButton.removeSelectionListener((SelectionListener)selectionListener);
    }

    private void initGuiEnvironmentEditor(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.envVariables");
        this.m_envTextArea = new Text(parent, 578);
        LayoutUtil.setMaxChar((Text)this.m_envTextArea, (int)4000);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.horizontalSpan = 2;
        textGridData.grabExcessHorizontalSpace = false;
        textGridData.widthHint = 250;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_envTextArea), (int)2);
        this.m_envTextArea.setLayoutData((Object)textGridData);
    }

    @Override
    protected void initState() {
        this.m_activationMethodCombo.setEnabled(true);
        this.m_envTextArea.setEnabled(true);
        this.checkLocalhostServer();
        RemoteFileBrowserBP.clearCache();
    }

    DialogStatusParameter modifyEnvFieldAction() {
        this.putConfigValue("ENVIRONMENT", this.m_envTextArea.getText());
        return null;
    }

    DialogStatusParameter modifyAutParamFieldAction() {
        String params = this.m_autArgsTextField.getText();
        this.putConfigValue("AUT_ARGUMENTS", params);
        return null;
    }

    boolean handleActivationComboEvent() {
        this.putConfigValue("ACTIVATION_METHOD", IAUTConfigPO.ActivationMethod.getRCString((IAUTConfigPO.ActivationMethod)((IAUTConfigPO.ActivationMethod)this.m_activationMethodCombo.getSelectedObject())));
        return true;
    }

    @Override
    protected void populateExpertArea(Map<String, String> data) {
        this.m_activationMethodCombo.setSelectedObject((Object)IAUTConfigPO.ActivationMethod.getEnum((String)data.get("ACTIVATION_METHOD")));
        if (!this.isDataNew(data)) {
            this.m_envTextArea.setText(StringUtils.defaultString((String)data.get("ENVIRONMENT")));
        }
    }

    @Override
    protected void populateAdvancedArea(Map<String, String> data) {
        this.m_autArgsTextField.setText(StringUtils.defaultString((String)data.get("AUT_ARGUMENTS")));
    }

    @Override
    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        if (!this.isDataNew(data)) {
            this.getServerCombo().select(this.getServerCombo().indexOf(StringUtils.defaultString((String)data.get("SERVER"))));
            this.m_execTextField.setText(StringUtils.defaultString((String)data.get("EXECUTABLE")));
        }
    }

    private void setWorkingDirToExecFilePath(String directory) {
        if ((StringUtils.isEmpty((String)this.getAutWorkingDirField().getText()) || this.isBasicMode()) && JavaFXAutConfigComponent.isFilePathAbsolute(directory) && this.m_isExecFieldValid) {
            File wd = new File(directory);
            if ((wd = wd.getParentFile()) != null) {
                String execPath = wd.getAbsolutePath();
                this.getAutWorkingDirField().setText(execPath);
                this.putConfigValue("WORKING_DIR", execPath);
            }
        }
    }

    private static boolean isFilePathAbsolute(String filename) {
        File execFile = new File(filename);
        return execFile.isAbsolute();
    }

    void browseLocal(String[] extensionFilters, String title, Text textField, String configVarKey) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 81920);
        if (extensionFilters != null) {
            fileDialog.setFilterExtensions(extensionFilters);
        }
        fileDialog.setText(title);
        String filterPath = Utils.getLastDirPath();
        File path = new File(textField.getText());
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), textField.getText());
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            textField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue(configVarKey, directory);
        }
    }

    void handleExecButtonEvent(FileDialog fileDialog) {
        fileDialog.setText(Messages.AUTConfigComponentSelectExecutable);
        String filterPath = Utils.getLastDirPath();
        File path = new File(this.getConfigValue("EXECUTABLE"));
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), this.getConfigValue("EXECUTABLE"));
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            this.m_execTextField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue("EXECUTABLE", directory);
            executablePath = directory;
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    private void handleExecButtonEventForRemote() {
        if (this.remoteBrowse(false, "EXECUTABLE", this.m_execTextField, Messages.AUTConfigComponentSelectExecutable)) {
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    DialogStatusParameter modifyExecTextField() {
        String filename;
        DialogStatusParameter error;
        block10: {
            error = null;
            this.m_isExecFieldValid = true;
            isExecFieldEmpty = this.m_execTextField.getText().length() == 0;
            filename = this.m_execTextField.getText();
            if (this.isValid((Widget)this.m_execTextField, true) && !isExecFieldEmpty) {
                if (this.checkLocalhostServer()) {
                    String workingDirString;
                    File file = new File(filename);
                    if (!file.isAbsolute() && (workingDirString = this.getConfigValue("WORKING_DIR")) != null && workingDirString.length() != 0) {
                        filename = String.valueOf(workingDirString) + "/" + filename;
                        file = new File(filename);
                    }
                    try {
                        if (!file.isFile()) {
                            error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)file.getCanonicalPath()));
                            break block10;
                        }
                        new JarFile(file);
                        error = this.createErrorStatus(NLS.bind((String)Messages.AUTConfigComponentFileJar, (Object)file.getCanonicalPath()));
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)filename));
                    }
                }
            } else if (!isExecFieldEmpty) {
                error = this.createErrorStatus(Messages.AUTConfigComponentWrongExecutable);
            }
        }
        if (error != null) {
            this.m_isExecFieldValid = false;
        }
        this.putConfigValue("EXECUTABLE", this.m_execTextField.getText());
        executablePath = filename;
        return error;
    }

    @Override
    protected boolean checkLocalhostServer() {
        boolean enable = super.checkLocalhostServer();
        boolean browseEnabled = enable || this.isRemoteRequest();
        this.m_execButton.setEnabled(browseEnabled && this.m_execButton.isEnabled());
        return enable;
    }

    @Override
    protected boolean isJavaAut() {
        return true;
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
        this.createAutDirectoryEditor(advancedAreaComposite);
        ControlDecorator.createInfo((Control)UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)I18n.getString((String)"AUTConfigComponent.autArguments")), "ControlDecorator.AUTArguments", false);
        this.m_autArgsTextField = UIComponentHelper.createTextField((Composite)advancedAreaComposite, (int)2);
        super.createAdvancedArea(advancedAreaComposite);
    }

    @Override
    protected void createExpertArea(Composite expertAreaComposite) {
        this.initGuiEnvironmentEditor(expertAreaComposite);
        UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.activationMethod");
        this.m_activationMethodCombo = UIComponentHelper.createEnumCombo((Composite)expertAreaComposite, (int)2, (String)"AUTConfigComponent.ActivationMethod", IAUTConfigPO.ActivationMethod.class);
        super.createExpertArea(expertAreaComposite);
    }

    @Override
    protected void openServerPrefPage() {
        boolean checkListeners;
        super.openServerPrefPage();
        boolean bl = checkListeners = this.m_selectionListener != null;
        if (checkListeners) {
            this.deinstallListeners();
        }
        if (checkListeners) {
            this.installListeners();
        }
    }

    private WidgetSelectionListener getSelectionListener() {
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new WidgetSelectionListener();
        }
        return this.m_selectionListener;
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    private WidgetFocusListener getFocusListener() {
        if (this.m_focusListener == null) {
            this.m_focusListener = new WidgetFocusListener();
        }
        return this.m_focusListener;
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyAutConfigFieldAction());
        this.addError(paramList, this.modifyAutParamFieldAction());
        this.addError(paramList, this.modifyEnvFieldAction());
        this.addError(paramList, this.modifyExecTextField());
        this.addError(paramList, this.modifyServerComboAction());
    }

    public void dispose() {
        RemoteFileBrowserBP.clearCache();
        super.dispose();
    }

    private class WidgetFocusListener
    implements FocusListener {
        private WidgetFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaFXAutConfigComponent.this.m_execTextField)) {
                JavaFXAutConfigComponent.this.setWorkingDirToExecFilePath(executablePath);
            }
        }
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaFXAutConfigComponent.this.getServerCombo())) {
                boolean checkListeners;
                JavaFXAutConfigComponent.this.checkLocalhostServer();
                boolean bl = checkListeners = JavaFXAutConfigComponent.this.m_selectionListener != null;
                if (checkListeners) {
                    JavaFXAutConfigComponent.this.deinstallListeners();
                }
                if (checkListeners) {
                    JavaFXAutConfigComponent.this.installListeners();
                }
            }
            JavaFXAutConfigComponent.this.checkAll();
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaFXAutConfigComponent.this.m_execButton)) {
                if (JavaFXAutConfigComponent.this.isRemoteRequest()) {
                    JavaFXAutConfigComponent.this.handleExecButtonEventForRemote();
                } else {
                    JavaFXAutConfigComponent.this.handleExecButtonEvent(new FileDialog(Plugin.getShell(), 81920));
                }
                return;
            }
            if (source.equals(JavaFXAutConfigComponent.this.m_activationMethodCombo)) {
                JavaFXAutConfigComponent.this.handleActivationComboEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "(" + source + ")" + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

