/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.businessprocess.ReflectionBP;
import org.eclipse.jubula.rc.common.classloader.ImplClassClassLoader;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.exception.ConfigXmlException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ComponentClass;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.xml.businessmodell.Profile;

public class AUTServerConfiguration {
    private static AutServerLogger log = new AutServerLogger(AUTServerConfiguration.class);
    private static AUTServerConfiguration instance = null;
    private Map m_implClassNames = new HashMap();
    private Map m_implClassCache = new HashMap();
    private Profile m_profile;
    private int m_keyMod;
    private int m_key;
    private int m_mouseButton;
    private int m_key2Mod;
    private int m_key2;
    private int m_checkModeKeyMod;
    private int m_checkModeKey;
    private int m_checkCompKeyMod;
    private int m_checkCompKey;
    private SortedSet m_singleLineTrigger;
    private SortedSet m_multiLineTrigger;
    private String m_projectToolkit;
    private List m_components = new ArrayList();
    private Set m_supportedComponentTypes;

    private AUTServerConfiguration() {
    }

    public static AUTServerConfiguration getInstance() {
        if (instance == null) {
            instance = new AUTServerConfiguration();
        }
        return instance;
    }

    public boolean isSupported(Object graphicsComponent) throws IllegalArgumentException {
        Validate.notNull((Object)graphicsComponent, (String)"graphics component must not be null");
        String className = graphicsComponent.getClass().getName();
        if (className.equals("com.bredexsw.guidancer.autserver.swing.implclasses.JMenuBarDefaultMapping")) {
            return true;
        }
        return this.m_implClassNames.containsKey(className);
    }

    private void registerImplementationClass(String componentClassName, String implClassName) throws IllegalArgumentException {
        Validate.notNull((Object)componentClassName);
        Validate.notNull((Object)implClassName);
        this.m_implClassNames.put(componentClassName, implClassName);
    }

    public Object getImplementationClass(Class componentClass) throws UnsupportedComponentException, IllegalArgumentException {
        Validate.notNull((Object)componentClass);
        Class currentClass = componentClass;
        String implClassName = (String)this.m_implClassNames.get(currentClass.getName());
        while (implClassName == null && currentClass.getSuperclass() != null) {
            currentClass = currentClass.getSuperclass();
            implClassName = (String)this.m_implClassNames.get(currentClass.getName());
        }
        return this.createInstance(componentClass.getName(), implClassName, currentClass.getClassLoader());
    }

    public Object getImplementationClass(String componentClassName) throws UnsupportedComponentException, IllegalArgumentException {
        Validate.notNull((Object)componentClassName);
        String implClassName = (String)this.m_implClassNames.get(componentClassName);
        return this.createInstance(componentClassName, implClassName, null);
    }

    private Object createInstance(String componentClassName, String implClassName, ClassLoader classLoader) throws UnsupportedComponentException {
        if (implClassName != null) {
            Class implClass = null;
            Object implInstance = this.m_implClassCache.get(implClassName);
            if (implInstance != null) {
                return implInstance;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Loading ImplementationClass: '" + String.valueOf(implClassName) + "'" + " with ClassLoader: " + "'" + String.valueOf(classLoader) + "'");
                }
                implClass = this.loadImplementationClass(implClassName, classLoader);
                implInstance = implClass.newInstance();
                if (!this.m_implClassCache.containsKey(implClassName)) {
                    this.m_implClassCache.put(implClassName, implInstance);
                }
            }
            catch (InstantiationException ie) {
                log.error(ie);
                throw new UnsupportedComponentException("component '" + implClass.getName() + "' could not be instantiated", MessageIDs.E_INSTANTIATION);
            }
            catch (IllegalAccessException iae) {
                log.error(iae);
                throw new UnsupportedComponentException("component '" + implClass.getName() + "' could not be accessed", MessageIDs.E_ILLEGAL_ACCESS);
            }
            catch (ClassNotFoundException cnfe) {
                log.error(cnfe);
                throw new UnsupportedComponentException("component '" + componentClassName + "' is not supported: implementation class '" + implClassName + "' not found", MessageIDs.E_COMPONENT_UNSUPPORTED);
            }
            return implInstance;
        }
        throw new UnsupportedComponentException("component '" + componentClassName + "' is not supported", MessageIDs.E_COMPONENT_UNSUPPORTED);
    }

    private Class loadImplementationClass(String implClassName, ClassLoader componentClassLoader) throws ClassNotFoundException {
        if (AUTServer.getInstance().isRcpAccessible()) {
            return this.getClass().getClassLoader().loadClass(implClassName);
        }
        URLClassLoader thisCL = (URLClassLoader)this.getClass().getClassLoader();
        ImplClassClassLoader implCL = new ImplClassClassLoader(thisCL, componentClassLoader);
        return ((ClassLoader)implCL).loadClass(implClassName);
    }

    public Class getTestableClass(Class component) throws IllegalArgumentException {
        Validate.notNull((Object)component);
        Class componentClass = component;
        while (componentClass.getSuperclass() != null) {
            String componentClassName = componentClass.getName();
            if (this.m_implClassNames.containsKey(componentClassName)) {
                return componentClass;
            }
            componentClass = componentClass.getSuperclass();
        }
        throw new IllegalArgumentException("component '" + component.getName() + "' is not supported");
    }

    public Object prepareImplementationClass(Object graphicsComponent, Class componentClass) throws UnsupportedComponentException, IllegalArgumentException {
        Validate.notNull((Object)graphicsComponent);
        Object implClass = this.getImplementationClass(componentClass);
        ReflectionBP.invokeMethod("setComponent", implClass, new Class[]{Object.class}, new Object[]{graphicsComponent});
        return implClass;
    }

    public List getComponents() {
        return this.m_components;
    }

    public void registerComponent(ConcreteComponent c) throws IllegalArgumentException {
        this.m_components.add(c);
        this.registerImplementationClass(c.getComponentClass(), c.getTesterClass());
    }

    public Component findComponent(String typeName) {
        Validate.notNull((Object)typeName);
        List list = this.getComponents();
        for (Component comp : list) {
            if (comp instanceof ConcreteComponent) {
                ConcreteComponent ccomp = (ConcreteComponent)comp;
                if (ccomp.getComponentClass() == null || !ccomp.getComponentClass().equals(typeName)) continue;
                return ccomp;
            }
            if (!comp.getType().equals(typeName)) continue;
            return comp;
        }
        String message = "Component " + typeName + " does not exist";
        log.error(message);
        throw new ConfigXmlException(message, MessageIDs.E_NO_COMPONENT);
    }

    public List findComponents(String typeName) {
        Validate.notNull((Object)typeName);
        List list = this.getComponents();
        Iterator it = list.iterator();
        LinkedList<ConcreteComponent> comps = new LinkedList<ConcreteComponent>();
        while (it.hasNext()) {
            ConcreteComponent ccomp;
            Component comp = (Component)it.next();
            if (!(comp instanceof ConcreteComponent) || (ccomp = (ConcreteComponent)comp).getComponentClass() == null || !ccomp.getComponentClass().equals(typeName)) continue;
            comps.add(ccomp);
        }
        if (!comps.isEmpty()) {
            return comps;
        }
        String message = "Component " + typeName + " does not exist";
        log.error(message);
        throw new ConfigXmlException(message, MessageIDs.E_NO_COMPONENT);
    }

    public String getComponentName(Object component) {
        String gdCompName = null;
        try {
            String compType = this.getTestableClass(component.getClass()).getName();
            Component gdComp = this.findComponent(compType);
            while (!(gdComp == null || gdComp.isVisible() && gdComp.isObservable() || gdComp.getRealized().isEmpty())) {
                List realizedComponents = gdComp.getRealized();
                gdComp = (Component)realizedComponents.get(0);
            }
            if (gdComp.getType() != null) {
                gdCompName = CompSystemI18n.getString((String)gdComp.getType());
            }
        }
        catch (IllegalArgumentException iae) {
            log.error("componentClassname has no registrered implementation class", iae);
        }
        return gdCompName;
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    public void setProfile(Profile p) {
        this.m_profile = p;
    }

    public int getKey() {
        return this.m_key;
    }

    public void setKey(int key) {
        this.m_key = key;
    }

    public void setMouseButton(int mouseButton) {
        this.m_mouseButton = mouseButton;
    }

    public int getMouseButton() {
        return this.m_mouseButton;
    }

    public int getKeyMod() {
        return this.m_keyMod;
    }

    public void setKeyMod(int keyMod) {
        this.m_keyMod = keyMod;
    }

    public int getKey2() {
        return this.m_key2;
    }

    public void setKey2(int key2) {
        this.m_key2 = key2;
    }

    public int getKey2Mod() {
        return this.m_key2Mod;
    }

    public void setKey2Mod(int mod) {
        this.m_key2Mod = mod;
    }

    public int getCheckModeKey() {
        return this.m_checkModeKey;
    }

    public void setCheckModeKey(int checkModeKey) {
        this.m_checkModeKey = checkModeKey;
    }

    public int getCheckModeKeyMod() {
        return this.m_checkModeKeyMod;
    }

    public void setCheckModeKeyMod(int checkModeKeyMod) {
        this.m_checkModeKeyMod = checkModeKeyMod;
    }

    public int getCheckCompKeyMod() {
        return this.m_checkCompKeyMod;
    }

    public void setCheckCompKeyMod(int checkCompKeyMod) {
        this.m_checkCompKeyMod = checkCompKeyMod;
    }

    public int getCheckCompKey() {
        return this.m_checkCompKey;
    }

    public void setCheckCompKey(int checkCompKey) {
        this.m_checkCompKey = checkCompKey;
    }

    public SortedSet getSingleLineTrigger() {
        return this.m_singleLineTrigger;
    }

    public void setSingleLineTrigger(SortedSet singleLineTrigger) {
        this.m_singleLineTrigger = singleLineTrigger;
    }

    public SortedSet getMultiLineTrigger() {
        return this.m_multiLineTrigger;
    }

    public void setMultiLineTrigger(SortedSet multiLineTrigger) {
        this.m_multiLineTrigger = multiLineTrigger;
    }

    public String getProjectToolkit() {
        return this.m_projectToolkit;
    }

    public void setProjectToolkit(String projectToolkit) {
        this.m_projectToolkit = projectToolkit;
    }

    public Set getSupportedTypes() {
        if (this.m_supportedComponentTypes != null) {
            return this.m_supportedComponentTypes;
        }
        this.m_supportedComponentTypes = new HashSet();
        List supportedComponents = AUTServerConfiguration.getInstance().getComponents();
        for (ConcreteComponent c : supportedComponents) {
            if (c.hasDefaultMapping()) continue;
            List ccl = c.getCompClass();
            for (ComponentClass cc : ccl) {
                this.m_supportedComponentTypes.add(cc);
            }
        }
        return this.m_supportedComponentTypes;
    }
}

