/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.eclipse.jubula.communication.message.MessageParam;
import org.eclipse.jubula.rc.common.exception.MethodParamException;

public class MethodParams {
    private List m_types = new ArrayList();
    private List m_objectValues = new ArrayList();

    public void add(MessageParam param) throws MethodParamException {
        try {
            Class<?> type = null;
            try {
                type = Class.forName(param.getType(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                type = Class.forName(String.class.getName(), true, Thread.currentThread().getContextClassLoader());
            }
            String stringValue = param.getValue() == null ? "" : param.getValue();
            Object objectValue = ConvertUtils.convert((String)stringValue, type);
            if (objectValue == null || !type.isAssignableFrom(objectValue.getClass())) {
                throw new MethodParamException("Failed converting " + stringValue + " into an instance of " + type, param);
            }
            this.m_types.add(type);
            this.m_objectValues.add(objectValue);
        }
        catch (ClassNotFoundException e) {
            throw new MethodParamException("Action parameter type not found: " + e, param);
        }
    }

    private Object[] createArray(Object[] dest, List source) {
        source.toArray(dest);
        return dest;
    }

    public List getTypesAsList() {
        return this.m_types;
    }

    public Class[] getTypes() {
        return this.m_types.isEmpty() ? null : (Class[])this.createArray(new Class[this.m_types.size()], this.m_types);
    }

    public List getValuesAsList() {
        return this.m_objectValues;
    }

    public Object[] getValues() {
        return this.m_objectValues.isEmpty() ? null : this.createArray(new Object[this.m_objectValues.size()], this.m_objectValues);
    }
}

