/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.components;

import java.lang.reflect.Field;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStages {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentStages.class);
    private static ObservableList<Stage> stages;

    static {
        Class<Stage> stageC = Stage.class;
        try {
            Field stagesField = stageC.getDeclaredField("stages");
            stagesField.setAccessible(true);
            Object fieldObj = stagesField.get(null);
            if (!(fieldObj instanceof ObservableList)) {
                throw new NoSuchFieldException("The type of the field is not the expected type");
            }
            stages = (ObservableList)fieldObj;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.error(e.getMessage());
        }
    }

    private CurrentStages() {
    }

    public static Stage getfirstStage() {
        return (Stage)stages.get(0);
    }

    public static Stage getfocusStage() {
        Stage fStage = null;
        for (Stage stage : stages) {
            if (!stage.isFocused()) continue;
            fStage = stage;
        }
        return fStage;
    }

    public static void addStagesListener(ListChangeListener<Stage> listener) {
        stages.addListener(listener);
    }

    public static void removeStagesListener(ListChangeListener<Stage> listener) {
        stages.removeListener(listener);
    }
}

