/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComboComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.tester.adapter.ListViewAdapter;
import org.eclipse.jubula.rc.javafx.util.TraverseHelper;

public class ComboBoxAdapter<T extends ComboBox>
extends JavaFXComponentAdapter<T>
implements IComboComponent {
    public ComboBoxAdapter(T objectToAdapt) {
        super(objectToAdapt);
    }

    public String getText() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object value = ((ComboBox)ComboBoxAdapter.this.getRealComponent()).getValue();
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
        });
    }

    public boolean isEditable() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isEditable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((ComboBox)ComboBoxAdapter.this.getRealComponent()).isEditable();
            }
        });
    }

    public void selectAll() {
        StepExecutionException.throwUnsupportedAction();
    }

    public int getSelectedIndex() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedIndex", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((ComboBox)ComboBoxAdapter.this.getRealComponent()).getSelectionModel().getSelectedIndex();
            }
        });
    }

    public void select(int index) {
        ListView lv = this.getComboBoxList();
        ComboBox comboBox = (ComboBox)this.getRealComponent();
        this.setOpenedStatus(comboBox, true);
        try {
            ListViewAdapter<ListView> listViewAdapter = new ListViewAdapter<ListView>(lv);
            listViewAdapter.clickOnIndex(index, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        finally {
            this.setOpenedStatus(comboBox, false);
        }
    }

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        StepExecutionException.throwUnsupportedAction();
    }

    public String[] getValues() {
        ListView lv = this.getComboBoxList();
        ComboBox comboBox = (ComboBox)this.getRealComponent();
        this.setOpenedStatus(comboBox, true);
        String[] values = new String[]{};
        try {
            ListViewAdapter<ListView> listViewAdapter = new ListViewAdapter<ListView>(lv);
            values = listViewAdapter.getValues();
        }
        finally {
            this.setOpenedStatus(comboBox, false);
        }
        return values;
    }

    private ListView getComboBoxList() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getValues", new Callable<ListView>(){

            @Override
            public ListView call() throws Exception {
                TraverseHelper<ListView> helper = new TraverseHelper<ListView>();
                ComboBox comboBox = (ComboBox)ComboBoxAdapter.this.getRealComponent();
                List<ListView> listViewList = helper.getInstancesOf((Parent)comboBox, ListView.class);
                if (listViewList.size() == 1) {
                    return listViewList.get(0);
                }
                ComboBoxListViewSkin comboBoxListViewSkin = (ComboBoxListViewSkin)comboBox.getSkin();
                return (ListView)comboBoxListViewSkin.getPopupContent();
            }
        });
    }

    private void setOpenedStatus(T comboBox, boolean openStatus) {
        if (comboBox.isShowing() != openStatus) {
            this.getRobot().click(comboBox, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
    }
}

