/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.installer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleIterator {
    private static final String BUNDLES_DIR = "bundles";
    private static final String FILE_PATTERN = "*.jar";
    private BundleContext m_context;
    private Enumeration m_urls;
    private URL m_url;
    private String m_bundleName;
    private Bundle m_bundle;

    public BundleIterator(BundleContext context, String bundleFolderSuffix) {
        this.m_context = context;
        this.m_urls = context.getBundle().findEntries(BUNDLES_DIR + bundleFolderSuffix, FILE_PATTERN, false);
        if (this.m_urls == null) {
            this.m_urls = Collections.enumeration(new ArrayList());
        }
    }

    public boolean hasNext() {
        return this.m_urls.hasMoreElements();
    }

    public Bundle next() {
        this.m_url = (URL)this.m_urls.nextElement();
        this.m_bundleName = BundleIterator.getBundleName(this.m_url);
        this.m_bundle = Platform.getBundle((String)this.m_bundleName);
        return this.m_bundle;
    }

    public Bundle installBundle() throws IOException, BundleException, SecurityException, IllegalStateException {
        if (this.m_bundle != null) {
            return this.m_bundle;
        }
        BufferedInputStream inputStream = new BufferedInputStream(this.m_url.openStream());
        try {
            this.m_bundle = this.m_context.installBundle(this.m_bundleName, (InputStream)inputStream);
        }
        finally {
            inputStream.close();
        }
        return this.m_bundle;
    }

    public boolean uninstallBundle() {
        if (this.m_bundle != null) {
            try {
                this.m_bundle.uninstall();
                return true;
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return false;
    }

    private static String getBundleName(URL url) {
        String urlString = url.getFile();
        int indexBegin = urlString.lastIndexOf(47) + 1;
        int indexEnd = urlString.lastIndexOf(95);
        return urlString.substring(indexBegin, indexEnd);
    }
}

