/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.tree;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeOperationContext
extends AbstractTreeOperationContext {
    private static AutServerLogger log = new AutServerLogger(TreeOperationContext.class);

    public TreeOperationContext(IEventThreadQueuer queuer, IRobot robot, Tree tree) {
        super(queuer, robot, (Object)tree);
    }

    protected String convertValueToText(Object node, int row) throws StepExecutionException {
        return this.getRenderedText(node);
    }

    public String getRenderedText(Object node) throws StepExecutionException {
        final TreeItem treeNode = (TreeItem)node;
        return (String)this.getQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return CAPUtil.getWidgetText((Widget)treeNode, treeNode.getText());
            }
        });
    }

    public boolean isVisible(Object node) {
        final TreeItem treeNode = (TreeItem)node;
        Boolean visible = (Boolean)this.getQueuer().invokeAndWait("isVisible", new IRunnable(){

            public Object run() {
                TreeItem item = treeNode;
                boolean vis = true;
                while (item != null && item.getParentItem() != null) {
                    vis = item.getParentItem().getExpanded();
                    item = item.getParentItem();
                }
                return vis ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    public Rectangle getVisibleRowBounds(Rectangle rowBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleRowBounds: " + rowBounds, new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TreeOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle visibleBounds = tree.getClientArea();
                return visibleBounds;
            }
        });
        Rectangle visibleTreeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleRowBounds = visibleTreeBounds.intersection(rowBounds);
        return visibleRowBounds;
    }

    public void collapseNode(Object node) {
        final TreeItem item = this.castToTreeItem(node);
        final Tree tree = (Tree)this.getTree();
        boolean doAction = this.isExpanded(item);
        if (doAction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Collapsing node: " + node));
            }
            this.getQueuer().invokeAndWait("collapse", new IRunnable(){

                public Object run() throws StepExecutionException {
                    Event collapseEvent = new Event();
                    collapseEvent.time = (int)System.currentTimeMillis();
                    collapseEvent.type = 18;
                    collapseEvent.widget = tree;
                    collapseEvent.item = item;
                    tree.notifyListeners(18, collapseEvent);
                    item.setExpanded(false);
                    tree.update();
                    return null;
                }
            });
        }
    }

    public void expandNode(Object node) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            final TreeItem item = this.castToTreeItem(node);
            final Tree tree = (Tree)this.getTree();
            boolean doAction = !this.isExpanded(item);
            Thread.currentThread().setContextClassLoader(tree.getClass().getClassLoader());
            this.getQueuer().invokeAndWait("Scroll Tree item: " + item + " to visible", new IRunnable(){

                public Object run() {
                    tree.showItem(item);
                    return null;
                }
            });
            Rectangle nodeBounds = this.getNodeBounds(node);
            Rectangle visibleNodeBounds = this.getVisibleRowBounds(nodeBounds);
            org.eclipse.swt.graphics.Rectangle swtVisibleNodeBounds = new org.eclipse.swt.graphics.Rectangle(visibleNodeBounds.x, visibleNodeBounds.y, visibleNodeBounds.width, visibleNodeBounds.height);
            this.getRobot().move((Object)tree, (Object)swtVisibleNodeBounds);
            if (doAction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Expanding node: " + node));
                    log.debug((Object)("Node bounds   : " + visibleNodeBounds));
                }
                this.getQueuer().invokeAndWait("expand", new IRunnable(){

                    public Object run() throws StepExecutionException {
                        Event expandEvent = new Event();
                        expandEvent.time = (int)System.currentTimeMillis();
                        expandEvent.type = 17;
                        expandEvent.widget = tree;
                        expandEvent.item = item;
                        tree.notifyListeners(17, expandEvent);
                        item.setExpanded(true);
                        tree.update();
                        return null;
                    }
                });
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public Object[] getRootNodes() {
        return (Object[])this.getQueuer().invokeAndWait("getRootNode", new IRunnable(){

            public Object run() {
                return ((Tree)TreeOperationContext.this.getTree()).getItems();
            }
        });
    }

    public boolean isExpanded(Object node) {
        final TreeItem item = this.castToTreeItem(node);
        return (Boolean)this.getQueuer().invokeAndWait("isExpanded: " + item, new IRunnable(){

            public Object run() {
                return item.getExpanded() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void clickNode(final Object node, ClickOptions clickOps) {
        TreeItem item = this.castToTreeItem(node);
        this.scrollNodeToVisible(item);
        SwtUtils.waitForDisplayIdle(item.getDisplay());
        org.eclipse.swt.graphics.Rectangle visibleRowBounds = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleNodeBounds " + node, new IRunnable(){

            public Object run() {
                Rectangle nodeBounds = TreeOperationContext.this.getNodeBounds(node);
                return SwtPointUtil.toSwtRectangle(TreeOperationContext.this.getVisibleRowBounds(nodeBounds));
            }
        });
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps.setScrollToVisible(false));
    }

    public void toggleNodeCheckbox(Object node) {
        final TreeItem item = this.castToTreeItem(node);
        this.scrollNodeToVisible(item);
        this.getQueuer().invokeAndWait("selectNodeCheckbox", new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TreeOperationContext.this.getTree();
                boolean toggledValue = !item.getChecked();
                item.setChecked(toggledValue);
                Event toggleEvent = new Event();
                toggleEvent.type = 13;
                toggleEvent.detail = 32;
                toggleEvent.widget = tree;
                toggleEvent.item = item;
                toggleEvent.button = 524288;
                toggleEvent.count = 1;
                toggleEvent.display = item.getDisplay();
                tree.notifyListeners(13, toggleEvent);
                return null;
            }
        });
    }

    public void verifyCheckboxSelection(Object node, boolean checked) {
        final TreeItem item = this.castToTreeItem(node);
        this.scrollNodeToVisible(item);
        Boolean checkSelected = (Boolean)this.getQueuer().invokeAndWait("verifyCheckboxSelection", new IRunnable(){

            public Object run() {
                return new Boolean(item.getChecked());
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkSelected);
    }

    public void scrollNodeToVisible(final Object node) {
        this.getQueuer().invokeAndWait("showItem: " + node, new IRunnable(){

            public Object run() {
                ((Tree)TreeOperationContext.this.getTree()).showItem(TreeOperationContext.this.castToTreeItem(node));
                return null;
            }
        });
        final Rectangle nodeBoundsRelativeToParent = this.getNodeBounds(node);
        final Tree tree = (Tree)this.getTree();
        this.getQueuer().invokeAndWait("getNodeBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = tree.getDisplay().map((Control)tree, (Control)tree.getParent(), new Point(nodeBoundsRelativeToParent.x, nodeBoundsRelativeToParent.y));
                nodeBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                nodeBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                tree.getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)SwtPointUtil.toSwtRectangle(nodeBoundsRelativeToParent));
    }

    public Object getChild(final Object parent, final int index) {
        if (parent == null) {
            Object[] rootNodes = this.getRootNodes();
            if (index < 0 || index >= rootNodes.length) {
                return null;
            }
            return rootNodes[index];
        }
        return this.getQueuer().invokeAndWait("getChild: " + parent + "; With index: " + index, new IRunnable(){

            public Object run() {
                TreeItem parentItem = TreeOperationContext.this.castToTreeItem(parent);
                try {
                    return parentItem.getItem(index);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        });
    }

    public Object getParent(final Object child) {
        return this.getQueuer().invokeAndWait("getParent: " + child, new IRunnable(){

            public Object run() {
                TreeItem childItem = TreeOperationContext.this.castToTreeItem(child);
                return childItem.getParentItem();
            }
        });
    }

    private TreeItem castToTreeItem(Object toCast) {
        try {
            return (TreeItem)toCast;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Object must be of type TreeItem");
        }
    }

    public Object getSelectedNode() {
        return this.getSelectedNodes()[0];
    }

    public Object[] getSelectedNodes() {
        return (Object[])this.getQueuer().invokeAndWait("getSelectedNodes", new IRunnable(){

            public Object run() {
                Object[] selectedItems = ((Tree)TreeOperationContext.this.getTree()).getSelection();
                SelectionUtil.validateSelection((Object[])selectedItems);
                return selectedItems;
            }
        });
    }

    public Object[] getChildren(Object parent) {
        if (parent == null) {
            return this.getRootNodes();
        }
        final TreeItem item = this.castToTreeItem(parent);
        return (Object[])this.getQueuer().invokeAndWait("getChildren: " + item, new IRunnable(){

            public Object run() {
                return item.getItems();
            }
        });
    }

    public int getNumberOfChildren(Object parent) {
        if (parent == null) {
            return this.getRootNodes().length;
        }
        final TreeItem item = this.castToTreeItem(parent);
        return (Integer)this.getQueuer().invokeAndWait("getChildren: " + item, new IRunnable(){

            public Object run() {
                return new Integer(item.getItemCount());
            }
        });
    }

    public Collection getNodeTextList(Object node) {
        final ArrayList res = new ArrayList();
        final TreeItem item = this.castToTreeItem(node);
        this.getQueuer().invokeAndWait("getNodeText: " + item, new IRunnable(){

            public Object run() {
                int colCount = ((Tree)TreeOperationContext.this.getTree()).getColumnCount();
                int i = 0;
                while (i < colCount) {
                    String textAtColumn = CAPUtil.getWidgetText((Widget)item, "TEST_TESTABLE_TEXT_" + i, item.getText(i));
                    if (textAtColumn != null) {
                        res.add(textAtColumn);
                    }
                    ++i;
                }
                String text = CAPUtil.getWidgetText((Widget)item, item.getText());
                if (text != null) {
                    res.add(text);
                }
                return null;
            }
        });
        return res;
    }

    public Rectangle getNodeBounds(final Object node) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getNodeBounds: " + node, new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TreeOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getRelativeWidgetBounds((Widget)((TreeItem)node), (Control)tree);
                return bounds;
            }
        });
        Rectangle nodeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        return nodeBounds;
    }

    public int getIndexOfChild(final Object parent, final Object child) {
        if (parent != null) {
            return (Integer)this.getQueuer().invokeAndWait("getIndexOfChild", new IRunnable(){

                public Object run() throws StepExecutionException {
                    return new Integer(((TreeItem)parent).indexOf((TreeItem)child));
                }
            });
        }
        Object[] rootNodes = this.getRootNodes();
        int i = 0;
        while (i < rootNodes.length) {
            if (rootNodes[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        return this.getNumberOfChildren(node) == 0;
    }
}

