/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.xml.businessmodell;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.tools.exception.ConfigXmlException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidAction;
import org.eclipse.jubula.tools.xml.businessmodell.InvalidComponent;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Component {
    private static final String ARG_SEPARATOR = ", ";
    private static Logger log = LoggerFactory.getLogger(Component.class);
    private List m_realized = new ArrayList();
    private List m_extendedTypes = new ArrayList();
    private List m_realizedTypes = new ArrayList();
    private Set m_realizers = new HashSet();
    private transient Set m_allRealizers = new HashSet();
    private List m_actions = new ArrayList();
    private String m_type;
    private ToolkitPluginDescriptor m_toolkitDesriptor;
    private boolean m_completionStarted = false;
    private boolean m_deprecated = false;
    private String m_changed;
    private boolean m_visible = true;
    private boolean m_completionDone = false;
    private boolean m_observable = true;

    public List getActions() {
        return this.m_actions;
    }

    public List getRealized() {
        return this.m_realized;
    }

    public List getRealizedTypes() {
        return this.m_realizedTypes;
    }

    public Set getAllRealized() {
        HashSet result = new HashSet();
        result.addAll(this.m_realized);
        for (Component comp : this.m_realized) {
            result.addAll(comp.getAllRealized());
        }
        return result;
    }

    public boolean isRealizing(String type) {
        Validate.notNull((Object)type, (String)"The component type name must not be null");
        for (Component comp : this.getAllRealized()) {
            if (!type.equals(comp.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isRealizer() {
        return !this.m_realized.isEmpty();
    }

    public boolean isCompatibleWith(String type) {
        return this.getType().equals(type) || this.isRealizing(type);
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public int getActionsSize() {
        return this.m_actions != null ? this.m_actions.size() : 0;
    }

    public void addAction(Action action) {
        for (Action present : this.m_actions) {
            if (present.equals(action)) {
                return;
            }
            if (!present.getName().equals(action.getName())) continue;
            String msg = "duplicate definition of Action " + action.getName() + " at component " + this.getType() + ": method " + present.getMethod() + " vs. method " + action.getMethod();
            log.error(msg);
            throw new ConfigXmlException(msg, MessageIDs.E_DUPLICATE_ACTION);
        }
        this.m_actions.add(action);
    }

    public Action findAction(String name) {
        Validate.notNull((Object)name);
        List actionList = this.getActions();
        for (Action action : actionList) {
            if (!name.equals(action.getName())) continue;
            return action;
        }
        String message = "Action " + name + " not found within component " + this.m_type;
        log.debug(message);
        return new InvalidAction();
    }

    public Action findActionByMethodSignature(String methodName, String[] argTypes) {
        Validate.notNull((Object)methodName);
        List actionList = this.getActions();
        for (Action action : actionList) {
            if (!this.isSignatureMatch(action, methodName, argTypes)) continue;
            return action;
        }
        StringBuffer sb = new StringBuffer("Action ");
        sb.append(methodName).append("(");
        int i = 0;
        while (i < argTypes.length) {
            sb.append(argTypes[i]);
            if (i < argTypes.length - 1) {
                sb.append(ARG_SEPARATOR);
            }
            ++i;
        }
        sb.append(") does not exist.");
        String message = sb.toString();
        log.error(message);
        throw new ConfigXmlException(message, MessageIDs.E_NO_ACTION);
    }

    private boolean isSignatureMatch(Action action, String methodName, String[] argTypes) {
        if (methodName.equals(action.getMethod())) {
            List actionParams = action.getParams();
            if (actionParams.size() != argTypes.length) {
                return false;
            }
            int i = 0;
            while (i < argTypes.length) {
                Param param = (Param)actionParams.get(i);
                if (!param.getType().equals(argTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isConcrete() {
        return false;
    }

    public void addRealizedType(String realized) {
        this.m_realizedTypes.add(realized);
    }

    private void addRealized(Component realized) {
        this.m_realized.add(realized);
    }

    public Set getRealizers() {
        return this.m_realizers;
    }

    public Set getAllRealizers() {
        return this.m_allRealizers;
    }

    boolean addRealizer(ConcreteComponent realizer) {
        return this.m_realizers.add(realizer);
    }

    boolean addAllRealizer(Component realizer) {
        return this.m_allRealizers.add(realizer);
    }

    void completeActions(CompSystem compSystem) {
        if (this.m_completionDone) {
            return;
        }
        if (this.m_completionStarted) {
            log.info("realization loop in component configuration for " + this.getType() + " (may be regarded as an error?)");
        }
        this.resolveRealized(compSystem);
        this.m_completionStarted = true;
        for (Component realized : this.m_realized) {
            realized.completeActions(compSystem);
            Iterator actionIt = realized.getActions().iterator();
            while (actionIt.hasNext()) {
                this.addAction((Action)actionIt.next());
            }
        }
        this.m_completionDone = true;
    }

    private void resolveRealized(CompSystem compSystem) {
        if (this.m_realized.isEmpty() && !this.m_realizedTypes.isEmpty()) {
            for (String type : this.m_realizedTypes) {
                Component comp = compSystem.findComponent(type);
                if (comp instanceof InvalidComponent) continue;
                this.addRealized(comp);
            }
            this.completeActions(compSystem);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Type", (Object)this.getType()).append("Actions", (Object)this.getActions()).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Component)) {
            return false;
        }
        Component rhs = (Component)obj;
        if (this.getType() != null) {
            return this.getType().equals(rhs.getType());
        }
        return false;
    }

    public int hashCode() {
        if (this.getType() != null) {
            return this.getType().hashCode();
        }
        return super.hashCode();
    }

    public boolean isDeprecated() {
        return this.m_deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.m_deprecated = deprecated;
    }

    public String getChanged() {
        return this.m_changed;
    }

    public void setChanged(String changed) {
        this.m_changed = changed;
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void setObservable(boolean observable) {
        this.m_observable = observable;
    }

    public boolean isObservable() {
        return this.m_observable;
    }

    public boolean isValid() {
        return true;
    }

    public ToolkitPluginDescriptor getToolkitDesriptor() {
        return this.m_toolkitDesriptor;
    }

    public void setToolkitDesriptor(ToolkitPluginDescriptor toolkitDesriptor) {
        this.m_toolkitDesriptor = toolkitDesriptor;
    }

    public List getExtendedTypes() {
        return this.m_extendedTypes;
    }

    public void addExtendedType(String extended) {
        this.m_extendedTypes.add(extended);
    }

    public boolean isExtender() {
        return !this.m_extendedTypes.isEmpty();
    }
}

