/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event;

public class CTFCallsite
implements Comparable<CTFCallsite> {
    private static final long MASK32 = 0xFFFFFFFFL;
    private final String fEventName;
    private final String fFileName;
    private final long fIp;
    private final String fFunctionName;
    private final long fLineNumber;

    public CTFCallsite(String en, String func, long ip, String fn, long line) {
        this.fEventName = en;
        this.fFileName = fn;
        this.fFunctionName = func;
        this.fIp = ip;
        this.fLineNumber = line;
    }

    public String getEventName() {
        return this.fEventName;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public long getIp() {
        return this.fIp;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public long getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public int compareTo(CTFCallsite o) {
        long other = o.fIp;
        long otherHigh = other >> 32 & 0xFFFFFFFFL;
        long otherLow = other & 0xFFFFFFFFL;
        long ownHigh = this.fIp >> 32 & 0xFFFFFFFFL;
        long ownLow = this.fIp & 0xFFFFFFFFL;
        if (ownHigh > otherHigh) {
            return 1;
        }
        if (ownHigh < otherHigh) {
            return -1;
        }
        if (ownLow > otherLow) {
            return 1;
        }
        if (ownLow < otherLow) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.fFileName) + "/" + this.fFunctionName + ":" + this.fLineNumber;
    }
}

