/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;

public abstract class Definition {
    private final String fFieldName;
    private final LexicalScope fPath;
    private final IDefinitionScope fDefinitionScope;
    @NonNull
    private final IDeclaration fDeclaration;

    public Definition(@NonNull IDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName) {
        this.fDeclaration = declaration;
        this.fDefinitionScope = definitionScope;
        this.fFieldName = fieldName;
        this.fPath = this.fDeclaration.getPath(definitionScope, fieldName);
    }

    protected String getFieldName() {
        return this.fFieldName;
    }

    public LexicalScope getScopePath() {
        return this.fPath;
    }

    protected IDefinitionScope getDefinitionScope() {
        return this.fDefinitionScope;
    }

    @NonNull
    public IDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String toString() {
        return String.valueOf(this.fPath.toString()) + '[' + Integer.toHexString(this.hashCode()) + ']';
    }
}

