/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class CTFStreamInputPacketReader
implements IDefinitionScope,
AutoCloseable {
    @NonNull
    private final BitBuffer fBitBuffer;
    private final CTFStreamInputReader fStreamInputReader;
    private final StructDeclaration fTracePacketHeaderDecl;
    private final StructDeclaration fStreamPacketContextDecl;
    private final StructDeclaration fStreamEventHeaderDecl;
    private final StructDeclaration fStreamEventContextDecl;
    private StructDefinition fCurrentTracePacketHeaderDef;
    private StructDefinition fCurrentStreamEventHeaderDef;
    private Definition fCurrentStreamPacketContextDef;
    private StreamInputPacketIndexEntry fCurrentPacket = null;
    private long fLastTimestamp = 0L;
    private int fCurrentCpu = 0;
    private int fLostEventsInThisPacket;
    private long fLostEventsDuration;
    private boolean fHasLost = false;

    public CTFStreamInputPacketReader(CTFStreamInputReader streamInputReader) {
        this.fStreamInputReader = streamInputReader;
        this.fBitBuffer = new BitBuffer();
        this.fBitBuffer.setByteOrder(streamInputReader.getByteOrder());
        CTFStream currentStream = streamInputReader.getStreamInput().getStream();
        this.fTracePacketHeaderDecl = currentStream.getTrace().getPacketHeader();
        this.fStreamPacketContextDecl = currentStream.getPacketContextDecl();
        this.fStreamEventHeaderDecl = currentStream.getEventHeaderDecl();
        this.fStreamEventContextDecl = currentStream.getEventContextDecl();
    }

    public StructDefinition getEventContextDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fStreamEventContextDecl.createDefinition(this, LexicalScope.STREAM_EVENT_CONTEXT.getName(), input);
    }

    public StructDefinition getStreamEventHeaderDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fStreamEventHeaderDecl.createDefinition(this, LexicalScope.STREAM_EVENT_HEADER.getName(), input);
    }

    public StructDefinition getStreamPacketContextDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fStreamPacketContextDecl.createDefinition(this, LexicalScope.STREAM_PACKET_CONTEXT.getName(), input);
    }

    public StructDefinition getTracePacketHeaderDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fTracePacketHeaderDecl.createDefinition(this, LexicalScope.TRACE_PACKET_HEADER.getName(), input);
    }

    @Override
    public void close() {
        this.fBitBuffer.setByteBuffer(null);
    }

    StreamInputPacketIndexEntry getCurrentPacket() {
        return this.fCurrentPacket;
    }

    public int getCPU() {
        return this.fCurrentCpu;
    }

    @Override
    public LexicalScope getScopePath() {
        return LexicalScope.PACKET;
    }

    void setCurrentPacket(StreamInputPacketIndexEntry currentPacket) throws CTFReaderException {
        StreamInputPacketIndexEntry prevPacket = null;
        this.fCurrentPacket = currentPacket;
        if (this.fCurrentPacket != null) {
            ByteBuffer bb = null;
            try {
                bb = this.fStreamInputReader.getStreamInput().getByteBufferAt(this.fCurrentPacket.getOffsetBytes(), (this.fCurrentPacket.getPacketSizeBits() + 7L) / 8L);
            }
            catch (IOException e) {
                throw new CTFReaderException(e.getMessage(), e);
            }
            this.fBitBuffer.setByteBuffer(bb);
            if (this.fTracePacketHeaderDecl != null) {
                this.fCurrentTracePacketHeaderDef = this.getTracePacketHeaderDefinition(this.fBitBuffer);
            }
            if (this.fStreamPacketContextDecl != null) {
                this.fCurrentStreamPacketContextDef = this.getStreamPacketContextDefinition(this.fBitBuffer);
                if (this.getCurrentPacket().getTarget() != null) {
                    this.fCurrentCpu = (int)this.getCurrentPacket().getTargetId();
                }
                this.fLostEventsInThisPacket = (int)this.getCurrentPacket().getLostEvents();
                if (this.fLostEventsInThisPacket != 0) {
                    long lostEventsStartTime;
                    this.fHasLost = true;
                    int index = this.fStreamInputReader.getStreamInput().getIndex().getEntries().indexOf(currentPacket);
                    if (index == 0) {
                        lostEventsStartTime = currentPacket.getTimestampBegin() + 1L;
                    } else {
                        prevPacket = this.fStreamInputReader.getStreamInput().getIndex().getEntries().get(index - 1);
                        lostEventsStartTime = prevPacket.getTimestampEnd();
                    }
                    this.fLostEventsDuration = Math.abs(lostEventsStartTime - currentPacket.getTimestampBegin());
                }
            }
            this.fLastTimestamp = currentPacket.getTimestampBegin();
        } else {
            this.fBitBuffer.setByteBuffer(null);
            this.fLastTimestamp = 0L;
        }
    }

    public boolean hasMoreEvents() {
        if (this.fCurrentPacket != null) {
            return this.fHasLost || this.fBitBuffer.position() < this.fCurrentPacket.getContentSizeBits();
        }
        return false;
    }

    public EventDefinition readNextEvent() throws CTFReaderException {
        IEventDeclaration eventDeclaration;
        long eventID = -2L;
        long timestamp = 0L;
        if (this.fHasLost) {
            this.fHasLost = false;
            EventDeclaration lostEventDeclaration = EventDeclaration.getLostEventDeclaration();
            StructDeclaration lostFields = lostEventDeclaration.getFields();
            IntegerDeclaration lostFieldsDecl = (IntegerDeclaration)lostFields.getFields().get("Lost events");
            if (lostFieldsDecl == null) {
                throw new IllegalStateException("Lost events count not declared!");
            }
            IntegerDeclaration lostEventsDurationDecl = (IntegerDeclaration)lostFields.getFields().get("duration");
            if (lostEventsDurationDecl == null) {
                throw new IllegalStateException("Lost events duration not declared!");
            }
            IntegerDefinition lostDurationDef = new IntegerDefinition(lostFieldsDecl, null, "duration", this.fLostEventsDuration);
            IntegerDefinition lostCountDef = new IntegerDefinition(lostEventsDurationDecl, null, "Lost events", this.fLostEventsInThisPacket);
            Definition[] fields = new IntegerDefinition[]{lostCountDef, lostDurationDef};
            ImmutableList fieldNameList = ImmutableList.builder().add((Object)"Lost events").add((Object)"duration").build();
            return new EventDefinition(lostEventDeclaration, this.fStreamInputReader, this.fLastTimestamp, null, null, null, new StructDefinition(lostFields, this, "fields", (List<String>)fieldNameList, fields));
        }
        BitBuffer currentBitBuffer = this.fBitBuffer;
        long posStart = currentBitBuffer.position();
        if (this.fStreamEventHeaderDecl != null) {
            Definition variantDef;
            this.fCurrentStreamEventHeaderDef = this.getStreamEventHeaderDefinition(currentBitBuffer);
            Definition idDef = this.fCurrentStreamEventHeaderDef.lookupDefinition("id");
            if (idDef instanceof SimpleDatatypeDefinition) {
                eventID = ((SimpleDatatypeDefinition)idDef).getIntegerValue();
            } else if (idDef != null) {
                throw new CTFReaderException("Incorrect event id : " + eventID);
            }
            IntegerDefinition timestampDef = this.fCurrentStreamEventHeaderDef.lookupInteger("timestamp");
            if (timestampDef != null) {
                timestamp = this.calculateTimestamp(timestampDef);
            }
            if ((variantDef = this.fCurrentStreamEventHeaderDef.lookupDefinition("v")) instanceof VariantDefinition) {
                Definition def;
                StructDefinition variantCurrentField = (StructDefinition)((VariantDefinition)variantDef).getCurrentField();
                Definition idIntegerDef = variantCurrentField.lookupDefinition("id");
                if (idIntegerDef instanceof IntegerDefinition) {
                    eventID = ((IntegerDefinition)idIntegerDef).getValue();
                }
                if ((def = variantCurrentField.lookupDefinition("timestamp")) instanceof IntegerDefinition) {
                    timestamp = this.calculateTimestamp((IntegerDefinition)def);
                }
            }
        }
        if ((eventDeclaration = this.fStreamInputReader.getStreamInput().getStream().getEvents().get(eventID)) == null) {
            throw new CTFReaderException("Incorrect event id : " + eventID);
        }
        EventDefinition eventDef = eventDeclaration.createDefinition(this.fStreamInputReader, this.fBitBuffer, timestamp);
        if (posStart == currentBitBuffer.position()) {
            throw new CTFReaderException("Empty event not allowed, event: " + eventDef.getDeclaration().getName());
        }
        return eventDef;
    }

    private long calculateTimestamp(IntegerDefinition timestampDef) {
        int len = timestampDef.getDeclaration().getLength();
        if (timestampDef.getDeclaration().getLength() == 64) {
            this.fLastTimestamp = timestampDef.getValue();
            return this.fLastTimestamp;
        }
        long majorasbitmask = (1L << len) - 1L;
        long newval = timestampDef.getValue();
        if (newval < (this.fLastTimestamp & majorasbitmask)) {
            newval += 1L << len;
        }
        this.fLastTimestamp &= majorasbitmask ^ 0xFFFFFFFFFFFFFFFFL;
        this.fLastTimestamp += newval;
        return this.fLastTimestamp;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals(LexicalScope.STREAM_PACKET_CONTEXT)) {
            return this.fCurrentStreamPacketContextDef;
        }
        if (lookupPath.equals(LexicalScope.TRACE_PACKET_HEADER)) {
            return this.fCurrentTracePacketHeaderDef;
        }
        return null;
    }

    public StructDefinition getCurrentStreamEventHeader() {
        return this.fCurrentStreamEventHeaderDef;
    }

    public StructDefinition getCurrentPacketEventHeader() {
        return this.fCurrentTracePacketHeaderDef;
    }
}

