/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFResponse;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInput;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.internal.ctf.core.Activator;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputReaderTimestampComparator;

public class CTFTraceReader
implements AutoCloseable {
    private static final int MIN_PRIO_SIZE = 16;
    private final CTFTrace fTrace;
    private final List<CTFStreamInputReader> fStreamInputReaders = new ArrayList<CTFStreamInputReader>();
    private PriorityQueue<CTFStreamInputReader> fPrio;
    private long[] fEventCountPerTraceFile;
    private long fStartTime;
    private long fEndTime;

    public CTFTraceReader(CTFTrace trace) throws CTFReaderException {
        this.fTrace = trace;
        this.fStreamInputReaders.clear();
        this.createStreamInputReaders();
        this.populateStreamInputReaderHeap();
        this.fStartTime = 0L;
        if (this.hasMoreEvents()) {
            this.fStartTime = this.fPrio.peek().getCurrentEvent().getTimestamp();
            this.setEndTime(this.fStartTime);
        }
    }

    public CTFTraceReader copyFrom() throws CTFReaderException {
        CTFTraceReader newReader = null;
        newReader = new CTFTraceReader(this.fTrace);
        newReader.fStartTime = this.fStartTime;
        newReader.setEndTime(this.fEndTime);
        return newReader;
    }

    @Override
    public void close() {
        for (CTFStreamInputReader reader : this.fStreamInputReaders) {
            if (reader == null) continue;
            reader.close();
        }
        this.fStreamInputReaders.clear();
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    protected final void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    protected PriorityQueue<CTFStreamInputReader> getPrio() {
        return this.fPrio;
    }

    private void createStreamInputReaders() throws CTFReaderException {
        for (CTFStream stream : this.fTrace.getStreams()) {
            Set<CTFStreamInput> streamInputs = stream.getStreamInputs();
            for (CTFStreamInput streamInput : streamInputs) {
                CTFStreamInputReader streamInputReader = new CTFStreamInputReader(streamInput);
                this.fStreamInputReaders.add(streamInputReader);
            }
        }
        this.fEventCountPerTraceFile = new long[this.fStreamInputReaders.size()];
    }

    public void update() throws CTFReaderException {
        HashSet<CTFStreamInputReader> readers = new HashSet<CTFStreamInputReader>();
        for (CTFStream stream : this.fTrace.getStreams()) {
            Set<CTFStreamInput> streamInputs = stream.getStreamInputs();
            for (CTFStreamInput streamInput : streamInputs) {
                CTFStreamInputReader streamInputReader = new CTFStreamInputReader(streamInput);
                if (this.fStreamInputReaders.contains(streamInputReader)) continue;
                streamInputReader.readNextEvent();
                this.fStreamInputReaders.add(streamInputReader);
                readers.add(streamInputReader);
            }
        }
        long[] temp = this.fEventCountPerTraceFile;
        this.fEventCountPerTraceFile = new long[readers.size() + temp.length];
        for (CTFStreamInputReader reader : readers) {
            this.fPrio.add(reader);
        }
        int i = 0;
        while (i < temp.length) {
            this.fEventCountPerTraceFile[i] = temp[i];
            ++i;
        }
    }

    public Iterable<IEventDeclaration> getEventDeclarations() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (CTFStreamInputReader sir : this.fStreamInputReaders) {
            builder.addAll(sir.getEventDeclarations());
        }
        return builder.build();
    }

    private void populateStreamInputReaderHeap() throws CTFReaderException {
        if (this.fStreamInputReaders.isEmpty()) {
            this.fPrio = new PriorityQueue<CTFStreamInputReader>(16, new StreamInputReaderTimestampComparator());
            return;
        }
        this.fPrio = new PriorityQueue<CTFStreamInputReader>(Math.max(this.fStreamInputReaders.size() * 2, 16), new StreamInputReaderTimestampComparator());
        int pos = 0;
        for (CTFStreamInputReader reader : this.fStreamInputReaders) {
            reader.setParent(this);
            CTFResponse readNextEvent = reader.readNextEvent();
            if (readNextEvent != CTFResponse.OK && readNextEvent != CTFResponse.WAIT) continue;
            this.fPrio.add(reader);
            this.fEventCountPerTraceFile[pos] = 0L;
            reader.setName(pos);
            ++pos;
        }
    }

    public EventDefinition getCurrentEventDef() {
        CTFStreamInputReader top = this.getTopStream();
        return top != null ? top.getCurrentEvent() : null;
    }

    public boolean advance() throws CTFReaderException {
        CTFStreamInputReader top = this.fPrio.poll();
        if (top == null) {
            return false;
        }
        switch (top.readNextEvent()) {
            case OK: {
                this.fPrio.add(top);
                long topEnd = this.fTrace.timestampCyclesToNanos(top.getCurrentEvent().getTimestamp());
                this.setEndTime(Math.max(topEnd, this.getEndTime()));
                int n = top.getName();
                this.fEventCountPerTraceFile[n] = this.fEventCountPerTraceFile[n] + 1L;
                if (top.getCurrentEvent() == null) break;
                this.fEndTime = Math.max(top.getCurrentEvent().getTimestamp(), this.fEndTime);
                break;
            }
            case WAIT: {
                this.fPrio.add(top);
                break;
            }
        }
        return this.hasMoreEvents();
    }

    public void goToLastEvent() throws CTFReaderException {
        this.seek(this.getEndTime());
        while (this.fPrio.size() > 1) {
            this.advance();
        }
    }

    public boolean seek(long timestamp) throws CTFReaderException {
        this.fPrio.clear();
        for (CTFStreamInputReader streamInputReader : this.fStreamInputReaders) {
            streamInputReader.seek(timestamp);
            if (streamInputReader.getCurrentEvent() == null) continue;
            this.fPrio.add(streamInputReader);
        }
        return this.hasMoreEvents();
    }

    public CTFStreamInputReader getTopStream() {
        return this.fPrio.peek();
    }

    public final boolean hasMoreEvents() {
        return this.fPrio.size() > 0;
    }

    public void printStats() {
        this.printStats(60);
    }

    public void printStats(int width) {
        int numEvents = 0;
        if (width == 0) {
            return;
        }
        long[] lArray = this.fEventCountPerTraceFile;
        int n = this.fEventCountPerTraceFile.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            numEvents = (int)((long)numEvents + i);
            ++n2;
        }
        int j = 0;
        while (j < this.fEventCountPerTraceFile.length) {
            CTFStreamInputReader se = this.fStreamInputReaders.get(j);
            long len = (long)width * this.fEventCountPerTraceFile[se.getName()] / (long)numEvents;
            StringBuilder sb = new StringBuilder(se.getFilename());
            sb.append("\t[");
            int i = 0;
            while ((long)i < len) {
                sb.append('+');
                ++i;
            }
            long i2 = len;
            while (i2 < (long)width) {
                sb.append(' ');
                ++i2;
            }
            sb.append("]\t" + this.fEventCountPerTraceFile[se.getName()] + " Events");
            Activator.log(sb.toString());
            ++j;
        }
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public void setLive(boolean live) {
        for (CTFStreamInputReader s : this.fPrio) {
            s.setLive(live);
        }
    }

    public boolean isLive() {
        return this.fPrio.peek().isLive();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fStartTime ^ this.fStartTime >>> 32);
        result = 31 * result + this.fStreamInputReaders.hashCode();
        result = 31 * result + (this.fTrace == null ? 0 : this.fTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFTraceReader)) {
            return false;
        }
        CTFTraceReader other = (CTFTraceReader)obj;
        if (!this.fStreamInputReaders.equals(other.fStreamInputReaders)) {
            return false;
        }
        return !(this.fTrace == null ? other.fTrace != null : !this.fTrace.equals(other.fTrace));
    }

    public String toString() {
        return "CTFTraceReader [trace=" + this.fTrace + ']';
    }

    public CTFTrace getTrace() {
        return this.fTrace;
    }
}

