/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInputReader;

public class EventDeclaration
implements IEventDeclaration {
    @NonNull
    private static final String FIELDS = "fields";
    @NonNull
    private static final String CONTEXT = "context";
    public static final long LOST_EVENT_ID = -1L;
    public static final long UNSET_EVENT_ID = -2L;
    private String fName;
    private StructDeclaration fContext = null;
    private StructDeclaration fFields = null;
    private Long fId = -2L;
    private CTFStream fStream = null;
    private long fLogLevel;
    private final Map<String, String> fCustomAttributes = new HashMap<String, String>();

    @Override
    public EventDefinition createDefinition(CTFStreamInputReader streamInputReader, @NonNull BitBuffer input, long timestamp) throws CTFReaderException {
        StructDeclaration streamEventContextDecl = streamInputReader.getStreamEventContextDecl();
        StructDefinition streamEventContext = streamEventContextDecl != null ? streamEventContextDecl.createDefinition(null, LexicalScope.STREAM_EVENT_CONTEXT.toString(), input) : null;
        StructDefinition packetContext = streamInputReader.getPacketReader().getCurrentPacketEventHeader();
        StructDefinition eventContext = this.fContext != null ? this.fContext.createDefinition(null, CONTEXT, input) : null;
        StructDefinition eventPayload = this.fFields != null ? this.fFields.createDefinition(null, FIELDS, input) : null;
        return new EventDefinition(this, streamInputReader, timestamp, streamEventContext, eventContext, packetContext, eventPayload);
    }

    public static synchronized EventDeclaration getLostEventDeclaration() {
        EventDeclaration lostEvent = new EventDeclaration();
        String[] fieldNames = new String[]{"Lost events", "duration"};
        Declaration[] fieldDeclarations = new Declaration[]{IntegerDeclaration.UINT_32B_DECL, IntegerDeclaration.UINT_64B_DECL};
        lostEvent.fFields = new StructDeclaration(fieldNames, fieldDeclarations);
        lostEvent.fId = -1L;
        lostEvent.fName = "Lost event";
        return lostEvent;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setContext(StructDeclaration context) {
        this.fContext = context;
    }

    public void setFields(StructDeclaration fields) {
        this.fFields = fields;
    }

    @Override
    public StructDeclaration getFields() {
        return this.fFields;
    }

    @Override
    public StructDeclaration getContext() {
        return this.fContext;
    }

    public void setId(long id) {
        this.fId = id;
    }

    @Override
    public Long getId() {
        return this.fId;
    }

    public void setStream(CTFStream stream) {
        this.fStream = stream;
    }

    @Override
    public CTFStream getStream() {
        return this.fStream;
    }

    public boolean nameIsSet() {
        return this.fName != null;
    }

    public boolean contextIsSet() {
        return this.fContext != null;
    }

    public boolean fieldsIsSet() {
        return this.fFields != null;
    }

    public boolean idIsSet() {
        return this.fId != null && this.fId != -2L;
    }

    public boolean streamIsSet() {
        return this.fStream != null;
    }

    @Override
    public long getLogLevel() {
        return this.fLogLevel;
    }

    public void setLogLevel(long level) {
        this.fLogLevel = level;
    }

    @Override
    public Set<String> getCustomAttributes() {
        return this.fCustomAttributes.keySet();
    }

    @Override
    public String getCustomAttribute(String key) {
        return this.fCustomAttributes.get(key);
    }

    public void setCustomAttribute(String key, String value) {
        this.fCustomAttributes.put(key, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDeclaration)) {
            return false;
        }
        EventDeclaration other = (EventDeclaration)obj;
        if (this.fContext == null ? other.fContext != null : !this.fContext.equals(other.fContext)) {
            return false;
        }
        if (this.fFields == null ? other.fFields != null : !this.fFields.equals(other.fFields)) {
            return false;
        }
        if (this.fId == null ? other.fId != null : !this.fId.equals(other.fId)) {
            return false;
        }
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        if (this.fStream == null ? other.fStream != null : !this.fStream.equals(other.fStream)) {
            return false;
        }
        return this.fCustomAttributes.equals(other.fCustomAttributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fContext == null ? 0 : this.fContext.hashCode());
        result = 31 * result + (this.fFields == null ? 0 : this.fFields.hashCode());
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fStream == null ? 0 : this.fStream.hashCode());
        result = 31 * result + this.fCustomAttributes.hashCode();
        return result;
    }
}

