/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.trace;

import java.util.HashMap;
import java.util.Map;

public class StreamInputPacketIndexEntry {
    private final long fOffsetBytes;
    private long fDataOffsetBits = 0L;
    private long fPacketSizeBits = 0L;
    private long fContentSizeBits = 0L;
    private long fTimestampBegin = 0L;
    private long fTimestampEnd = 0L;
    private long fLostEvents = 0L;
    private String fTarget;
    private long fTargetID;
    private final Map<String, Object> fAttributes = new HashMap<String, Object>();

    public StreamInputPacketIndexEntry(long offset) {
        this.fOffsetBytes = offset;
    }

    boolean includes(long ts) {
        return ts >= this.fTimestampBegin && ts <= this.fTimestampEnd;
    }

    public String toString() {
        return "StreamInputPacketIndexEntry [offsetBytes=" + this.fOffsetBytes + ", timestampBegin=" + this.fTimestampBegin + ", timestampEnd=" + this.fTimestampEnd + "]";
    }

    public long getOffsetBytes() {
        return this.fOffsetBytes;
    }

    public long getDataOffsetBits() {
        return this.fDataOffsetBits;
    }

    public void setDataOffsetBits(long dataOffsetBits) {
        this.fDataOffsetBits = dataOffsetBits;
    }

    public long getPacketSizeBits() {
        return this.fPacketSizeBits;
    }

    public void setPacketSizeBits(long packetSizeBits) {
        this.fPacketSizeBits = packetSizeBits;
    }

    public long getContentSizeBits() {
        return this.fContentSizeBits;
    }

    public void setContentSizeBits(long contentSizeBits) {
        this.fContentSizeBits = contentSizeBits;
    }

    public long getTimestampBegin() {
        return this.fTimestampBegin;
    }

    public void setTimestampBegin(long timestampBegin) {
        this.fTimestampBegin = timestampBegin;
    }

    public long getTimestampEnd() {
        return this.fTimestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.fTimestampEnd = timestampEnd;
    }

    public long getLostEvents() {
        return this.fLostEvents;
    }

    public void setLostEvents(long lostEvents) {
        this.fLostEvents = lostEvents;
    }

    public void addAttribute(String field, Object value) {
        this.fAttributes.put(field, value);
    }

    public Object lookupAttribute(String field) {
        return this.fAttributes.get(field);
    }

    public String getTarget() {
        return this.fTarget;
    }

    public void setTarget(String target) {
        this.fTarget = target;
        this.fTargetID = Integer.parseInt(target.replaceAll("[\\D]", ""));
    }

    public long getTargetId() {
        return this.fTargetID;
    }
}

