/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gdbtrace.core.trace;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.linuxtools.internal.gdbtrace.core.trace.DsfGdbAdaptor;
import org.eclipse.linuxtools.internal.gdbtrace.core.trace.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.location.TmfLongLocation;

public class GdbTrace
extends TmfTrace
implements ITmfEventParser {
    private static final int CACHE_SIZE = 20;
    public static final QualifiedName EXEC_KEY = new QualifiedName("org.eclipse.linuxtools.gdbtrace.core", "executable");
    private DsfGdbAdaptor fGdbTpRef;
    private long fNbFrames = 0L;
    long fLocation;

    public GdbTrace() {
        this.setCacheSize(20);
    }

    public IStatus validate(IProject project, String path) {
        if (this.fileExists(path)) {
            if (new File(path).isFile()) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.linuxtools.gdbtrace.core", String.valueOf(Messages.GdbTrace_GdbTracesMustBeAFile) + ": " + path + " " + Messages.GdbTrace_IsNotAFile);
        }
        return new Status(4, "org.eclipse.linuxtools.gdbtrace.core", String.valueOf(Messages.GdbTrace_FileNotFound) + ": " + path);
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        try {
            String tracedExecutable = resource.getPersistentProperty(EXEC_KEY);
            if (tracedExecutable == null) {
                throw new TmfTraceException(Messages.GdbTrace_ExecutableNotSet);
            }
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
            this.fGdbTpRef = new DsfGdbAdaptor(this, defaultGdbCommand, path, tracedExecutable);
            this.fNbFrames = this.getNbFrames();
        }
        catch (CoreException e) {
            throw new TmfTraceException(Messages.GdbTrace_FailedToInitializeTrace, (Throwable)e);
        }
        super.initTrace(resource, path, type);
    }

    public synchronized void dispose() {
        if (this.fGdbTpRef != null) {
            this.fGdbTpRef.dispose();
        }
        super.dispose();
    }

    public String getDsfSessionId() {
        return this.fGdbTpRef.getSessionId();
    }

    public synchronized long getNbFrames() {
        this.fNbFrames = this.fGdbTpRef.getNumberOfFrames();
        return this.fNbFrames;
    }

    public synchronized TmfContext seekEvent(ITmfLocation location) {
        this.fLocation = location != null ? (Long)location.getLocationInfo() : 0L;
        return new TmfContext((ITmfLocation)new TmfLongLocation(this.fLocation), this.fLocation);
    }

    public synchronized ITmfContext seekEvent(double ratio) {
        TmfContext context = this.seekEvent((long)ratio * this.getNbEvents());
        return context;
    }

    public double getLocationRatio(ITmfLocation location) {
        if (this.getNbEvents() > 0L && location instanceof TmfLongLocation) {
            return (double)((TmfLongLocation)location).getLocationInfo().longValue() / (double)this.getNbEvents();
        }
        return 0.0;
    }

    public ITmfLocation getCurrentLocation() {
        return new TmfLongLocation(this.fLocation);
    }

    public GdbTraceEvent parseEvent(ITmfContext context) {
        if (context.getRank() >= this.fNbFrames) {
            return null;
        }
        GdbTraceEvent event = this.fGdbTpRef.selectAndReadFrame(context.getRank());
        ++this.fLocation;
        return event;
    }

    public synchronized TmfContext seekEvent(ITmfTimestamp timestamp) {
        long rank = timestamp.getValue();
        return this.seekEvent(rank);
    }

    public synchronized TmfContext seekEvent(long rank) {
        this.fLocation = rank;
        TmfContext context = new TmfContext((ITmfLocation)new TmfLongLocation(this.fLocation), rank);
        return context;
    }

    public synchronized void selectFrame(long rank) {
        this.fGdbTpRef.selectDataFrame(rank, true);
    }
}

