/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.linuxtools.internal.lttng2.control.core.relayd.lttngviewerCommands.IRelayResponse;

public class StreamResponse
implements IRelayResponse {
    public static final int SIZE = 4371;
    private final long fId;
    private final long fCtfTraceId;
    private final int fMetadataFlag;
    private final String fPathName;
    private final String fChannelName;

    public StreamResponse(DataInputStream inNet) throws IOException {
        byte[] streamData = new byte[4371];
        inNet.readFully(streamData, 0, 4371);
        ByteBuffer bb = ByteBuffer.wrap(streamData);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fId = bb.getLong();
        this.fCtfTraceId = bb.getLong();
        this.fMetadataFlag = bb.getInt();
        byte[] pathName = new byte[4096];
        byte[] channelName = new byte[255];
        bb.get(pathName, 0, 4096);
        bb.get(channelName, 0, 255);
        this.fPathName = new String(pathName);
        this.fChannelName = new String(channelName);
    }

    public long getId() {
        return this.fId;
    }

    public long getCtfTraceId() {
        return this.fCtfTraceId;
    }

    public int getMetadataFlag() {
        return this.fMetadataFlag;
    }

    public String getPathName() {
        return this.fPathName;
    }

    public String getChannelName() {
        return this.fChannelName;
    }
}

