/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider;

import org.eclipse.linuxtools.internal.lttng2.kernel.core.StateValues;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class LttngKernelStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 4;

    public LttngKernelStateProvider(ITmfTrace trace) {
        super(trace, ITmfEvent.class, "LTTng Kernel");
    }

    public int getVersion() {
        return 4;
    }

    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        super.assignTargetStateSystem(ssb);
    }

    public LttngKernelStateProvider getNewInstance() {
        return new LttngKernelStateProvider(this.getTrace());
    }

    protected void eventHandle(ITmfEvent event) {
        String eventName = event.getType().getName();
        long ts = event.getTimestamp().getValue();
        try {
            Integer currentCPUNode = this.ss.getQuarkRelativeAndAdd(this.getNodeCPUs(), new String[]{event.getSource()});
            int quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Current_thread"});
            ITmfStateValue value = this.ss.queryOngoingState(quark);
            int thread = value.isNull() ? -1 : value.unboxInt();
            Integer currentThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{String.valueOf(thread)});
            switch (eventName) {
                case "exit_syscall": {
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"System_call"});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = StateValues.CPU_STATUS_RUN_USERMODE_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case "irq_handler_entry": {
                    Integer irqId = ((Long)event.getContent().getField("irq").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeIRQs(), new String[]{irqId.toString()});
                    value = TmfStateValue.newValueInt((int)Integer.parseInt(event.getSource()));
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_INTERRUPTED_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = StateValues.CPU_STATUS_IRQ_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case "irq_handler_exit": {
                    Integer irqId = ((Long)event.getContent().getField("irq").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeIRQs(), new String[]{irqId.toString()});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, currentThreadNode);
                    this.cpuExitInterrupt(ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case "softirq_entry": {
                    Integer softIrqId = ((Long)event.getContent().getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeSoftIRQs(), new String[]{softIrqId.toString()});
                    value = TmfStateValue.newValueInt((int)Integer.parseInt(event.getSource()));
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_INTERRUPTED_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = StateValues.CPU_STATUS_SOFTIRQ_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case "softirq_exit": {
                    Integer softIrqId = ((Long)event.getContent().getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeSoftIRQs(), new String[]{softIrqId.toString()});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, currentThreadNode);
                    this.cpuExitInterrupt(ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case "softirq_raise": {
                    Integer softIrqId = ((Long)event.getContent().getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeSoftIRQs(), new String[]{softIrqId.toString()});
                    value = StateValues.SOFT_IRQ_RAISED_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case "sched_switch": {
                    ITmfEventField content = event.getContent();
                    Integer prevTid = ((Long)content.getField("prev_tid").getValue()).intValue();
                    Long prevState = (Long)content.getField("prev_state").getValue();
                    String nextProcessName = (String)content.getField("next_comm").getValue();
                    Integer nextTid = ((Long)content.getField("next_tid").getValue()).intValue();
                    Integer formerThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{prevTid.toString()});
                    Integer newCurrentThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{nextTid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Status"});
                    value = prevState != 0L ? StateValues.PROCESS_STATUS_WAIT_BLOCKED_VALUE : StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, newCurrentThreadNode);
                    quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)nextProcessName);
                    this.ss.modifyAttribute(ts, value, quark);
                    this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"});
                    this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"PPID"});
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Current_thread"});
                    value = TmfStateValue.newValueInt((int)nextTid);
                    this.ss.modifyAttribute(ts, value, quark);
                    value = nextTid > 0 ? (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"})).isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE) : StateValues.CPU_STATUS_IDLE_VALUE;
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case "sched_process_fork": {
                    ITmfEventField content = event.getContent();
                    String childProcessName = (String)content.getField("child_comm").getValue();
                    Integer parentTid = ((Long)content.getField("parent_tid").getValue()).intValue();
                    Integer childTid = ((Long)content.getField("child_tid").getValue()).intValue();
                    Integer parentTidNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{parentTid.toString()});
                    Integer childTidNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{childTid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PPID"});
                    value = TmfStateValue.newValueInt((int)parentTid);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)childProcessName);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Status"});
                    value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"System_call"});
                    value = this.ss.queryOngoingState(quark);
                    if (value.isNull()) {
                        value = TmfStateValue.newValueString((String)"sys_clone");
                    }
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"System_call"});
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case "sched_process_free": {
                    Integer tid = ((Long)event.getContent().getField("tid").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{tid.toString()});
                    this.ss.removeAttribute(ts, quark);
                    break;
                }
                case "lttng_statedump_process_state": {
                    ITmfEventField content = event.getContent();
                    int tid = ((Long)content.getField("tid").getValue()).intValue();
                    int pid = ((Long)content.getField("pid").getValue()).intValue();
                    int ppid = ((Long)content.getField("ppid").getValue()).intValue();
                    int status = ((Long)content.getField("status").getValue()).intValue();
                    String name = (String)content.getField("name").getValue();
                    int curThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{String.valueOf(tid)});
                    quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Exec_name"});
                    if (this.ss.queryOngoingState(quark).isNull()) {
                        value = TmfStateValue.newValueString((String)name);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PPID"})).isNull()) {
                        value = pid == tid ? TmfStateValue.newValueInt((int)ppid) : TmfStateValue.newValueInt((int)pid);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Status"})).isNull()) {
                        value = status == 2 ? StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE : (status == 5 ? StateValues.PROCESS_STATUS_WAIT_BLOCKED_VALUE : StateValues.PROCESS_STATUS_UNKNOWN_VALUE);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
                case "sched_wakeup": 
                case "sched_wakeup_new": {
                    int tid = ((Long)event.getContent().getField("tid").getValue()).intValue();
                    int threadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{String.valueOf(tid)});
                    quark = this.ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Status"});
                    int status = this.ss.queryOngoingState(quark).unboxInt();
                    if (status != 3 && status != 2) {
                        value = StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE;
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
                default: {
                    if (eventName.startsWith("sys_") || eventName.startsWith("compat_sys_")) {
                        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"System_call"});
                        value = TmfStateValue.newValueString((String)eventName);
                        this.ss.modifyAttribute(ts, value, quark);
                        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                        value = StateValues.PROCESS_STATUS_RUN_SYSCALL_VALUE;
                        this.ss.modifyAttribute(ts, value, quark);
                        quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                        value = StateValues.CPU_STATUS_RUN_SYSCALL_VALUE;
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
                case "sched_process_exit": {
                    return;
                }
            }
        }
        catch (AttributeNotFoundException ae) {
            ae.printStackTrace();
        }
        catch (TimeRangeException tre) {
            System.err.println("TimeRangeExcpetion caught in the state system's event manager.");
            System.err.println("Are the events in the trace correctly ordered?");
            tre.printStackTrace();
        }
        catch (StateValueTypeException sve) {
            sve.printStackTrace();
        }
    }

    private int getNodeCPUs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }

    private int getNodeThreads() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    private int getNodeIRQs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"Resources", "IRQs"});
    }

    private int getNodeSoftIRQs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"Resources", "Soft_IRQs"});
    }

    private void setProcessToRunning(long ts, int currentThreadNode) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        int quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        ITmfStateValue value = this.ss.queryOngoingState(quark).isNull() ? StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE : StateValues.PROCESS_STATUS_RUN_SYSCALL_VALUE;
        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
        this.ss.modifyAttribute(ts, value, quark);
    }

    private void cpuExitInterrupt(long ts, int currentCpuNode, int currentThreadNode) throws StateValueTypeException, AttributeNotFoundException, TimeRangeException {
        int quark = this.ss.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Current_thread"});
        ITmfStateValue value = this.ss.queryOngoingState(quark).unboxInt() > 0 ? (this.ss.queryOngoingState(quark = this.ss.getQuarkRelative(currentThreadNode, new String[]{"System_call"})).isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE) : StateValues.CPU_STATUS_IDLE_VALUE;
        quark = this.ss.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Status"});
        this.ss.modifyAttribute(ts, value, quark);
    }
}

