/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.analysis;

import com.google.common.collect.ImmutableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider.LttngKernelStateProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.analysis.Messages;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;

public class LttngKernelAnalysisModule
extends TmfStateSystemAnalysisModule {
    @NonNull
    public static final String HISTORY_TREE_FILE_NAME = "stateHistory.ht";
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.analysis";
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of();
    private static final ImmutableSet<String> OPTIONAL_EVENTS = ImmutableSet.of((Object)"exit_syscall", (Object)"irq_handler_entry", (Object)"irq_handler_exit", (Object)"softirq_entry", (Object)"softirq_exit", (Object)"softirq_raise", (Object[])new String[]{"sched_process_fork", "sched_process_exit", "sched_process_free", "sched_switch", "lttng_statedump_process_state", "sched_wakeup", "sched_wakeup_new", "sys_"});
    private static final ImmutableSet<TmfAnalysisRequirement> REQUIREMENTS;

    static {
        TmfAnalysisRequirement domainReq = new TmfAnalysisRequirement("domain");
        domainReq.addValue("KERNEL", TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        TmfAnalysisRequirement eventReq = new TmfAnalysisRequirement("event", REQUIRED_EVENTS, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        eventReq.addValues(OPTIONAL_EVENTS, TmfAnalysisRequirement.ValuePriorityLevel.OPTIONAL);
        REQUIREMENTS = ImmutableSet.of((Object)domainReq, (Object)eventReq);
    }

    @NonNull
    protected ITmfStateProvider createStateProvider() {
        return new LttngKernelStateProvider(this.getTrace());
    }

    @NonNull
    protected String getSsFileName() {
        return HISTORY_TREE_FILE_NAME;
    }

    protected String getFullHelpText() {
        return Messages.LttngKernelAnalysisModule_Help;
    }

    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        return REQUIREMENTS;
    }
}

