/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.cpuusage;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng2.kernel.core.Activator;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class LttngKernelCpuStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private final Map<String, Long> fLastStartTimes = new HashMap<String, Long>();
    private final long fTraceStart;

    public LttngKernelCpuStateProvider(ITmfTrace trace) {
        super(trace, ITmfEvent.class, "LTTng Kernel CPU usage");
        this.fTraceStart = trace.getStartTime().getValue();
    }

    public int getVersion() {
        return 1;
    }

    public LttngKernelCpuStateProvider getNewInstance() {
        return new LttngKernelCpuStateProvider(this.getTrace());
    }

    protected void eventHandle(ITmfEvent event) {
        String eventName = event.getType().getName();
        if (eventName.equals("sched_switch")) {
            ITmfEventField content = event.getContent();
            long ts = event.getTimestamp().getValue();
            String cpu = event.getSource();
            Long prevTid = (Long)content.getField("prev_tid").getValue();
            try {
                Integer currentCPUNode = this.ss.getQuarkRelativeAndAdd(this.getNodeCPUs(), new String[]{cpu});
                Integer cumulativeTimeQuark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{prevTid.toString()});
                Long startTime = this.fLastStartTimes.get(cpu);
                if (startTime == null) {
                    startTime = this.fTraceStart;
                }
                if (startTime != null) {
                    ITmfStateValue value = this.ss.queryOngoingState(cumulativeTimeQuark.intValue());
                    long prevCumulativeTime = value.unboxLong();
                    long newCumulativeTime = prevCumulativeTime + (ts - startTime);
                    value = TmfStateValue.newValueLong((long)newCumulativeTime);
                    this.ss.modifyAttribute(ts, value, cumulativeTimeQuark.intValue());
                    this.fLastStartTimes.put(cpu, ts);
                }
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError("Attribute not found in LttngKernelCpuStateProvider", e);
            }
        }
    }

    private int getNodeCPUs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }
}

