/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.cpuusage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.kernel.core.Activator;
import org.eclipse.linuxtools.lttng2.kernel.core.analysis.LttngKernelAnalysisModule;
import org.eclipse.linuxtools.lttng2.kernel.core.cpuusage.LttngKernelCpuStateProvider;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;

public class LttngKernelCpuUsageAnalysis
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.core.cpuusage";
    public static final String TOTAL = "total";
    public static final String SPLIT_STRING = "/";
    public static final String TID_ZERO = "0";

    protected ITmfStateProvider createStateProvider() {
        return new LttngKernelCpuStateProvider(this.getTrace());
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) {
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)this.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module != null) {
            module.schedule();
        }
        return super.executeAnalysis(monitor);
    }

    public Map<String, Long> getCpuUsageInRange(long start, long end) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        HashMap<String, Long> totalMap = new HashMap<String, Long>();
        ITmfStateSystem cpuSs = this.getStateSystem();
        if (cpuSs == null) {
            return map;
        }
        TmfStateSystemAnalysisModule module = (TmfStateSystemAnalysisModule)this.getTrace().getAnalysisModuleOfClass(TmfStateSystemAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return map;
        }
        module.schedule();
        module.waitForInitialization();
        ITmfStateSystem kernelSs = module.getStateSystem();
        if (kernelSs == null) {
            return map;
        }
        long startTime = Math.max(start, cpuSs.getStartTime());
        startTime = Math.max(startTime, kernelSs.getStartTime());
        long endTime = Math.min(end, cpuSs.getCurrentEndTime());
        endTime = Math.min(endTime, kernelSs.getCurrentEndTime());
        long totalTime = 0L;
        if (endTime < startTime) {
            return map;
        }
        try {
            int cpusNode = cpuSs.getQuarkAbsolute(new String[]{"CPUs"});
            HashMap<Integer, List> tidsPerCpu = new HashMap<Integer, List>();
            Iterator iterator = cpuSs.getSubAttributes(cpusNode, false).iterator();
            while (iterator.hasNext()) {
                int cpuNode = (Integer)iterator.next();
                tidsPerCpu.put(cpuNode, cpuSs.getSubAttributes(cpuNode, false));
            }
            List kernelEndState = kernelSs.queryFullState(endTime);
            List endState = cpuSs.queryFullState(endTime);
            List kernelStartState = kernelSs.queryFullState(startTime);
            List startState = cpuSs.queryFullState(startTime);
            for (Map.Entry entry : tidsPerCpu.entrySet()) {
                int cpuNode = (Integer)entry.getKey();
                List tidNodes = (List)entry.getValue();
                String curCpuName = cpuSs.getAttributeName(cpuNode);
                long cpuTotal = 0L;
                int currentThreadQuark = kernelSs.getQuarkAbsolute(new String[]{"CPUs", curCpuName, "Current_thread"});
                int startThread = ((ITmfStateInterval)kernelStartState.get(currentThreadQuark)).getStateValue().unboxInt();
                int endThread = ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getStateValue().unboxInt();
                Iterator iterator2 = tidNodes.iterator();
                while (iterator2.hasNext()) {
                    long currentCount;
                    long runningEnd;
                    long runningTime;
                    int tidNode = (Integer)iterator2.next();
                    String curTidName = cpuSs.getAttributeName(tidNode);
                    int tid = Integer.parseInt(curTidName);
                    long countAtEnd = ((ITmfStateInterval)endState.get(tidNode)).getStateValue().unboxLong();
                    long countAtStart = ((ITmfStateInterval)startState.get(tidNode)).getStateValue().unboxLong();
                    if (countAtStart == -1L) {
                        countAtStart = 0L;
                    }
                    if (countAtEnd == -1L) {
                        countAtEnd = 0L;
                    }
                    if (tid == startThread || startThread == -1) {
                        runningTime = ((ITmfStateInterval)kernelStartState.get(currentThreadQuark)).getEndTime() - ((ITmfStateInterval)kernelStartState.get(currentThreadQuark)).getStartTime();
                        runningEnd = ((ITmfStateInterval)kernelStartState.get(currentThreadQuark)).getEndTime();
                        countAtStart = LttngKernelCpuUsageAnalysis.interpolateCount(countAtStart, startTime, runningEnd, runningTime);
                    }
                    if (tid == endThread) {
                        runningTime = ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getEndTime() - ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getStartTime();
                        runningEnd = ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getEndTime();
                        countAtEnd = LttngKernelCpuUsageAnalysis.interpolateCount(countAtEnd, endTime, runningEnd, runningTime);
                    }
                    if (startThread == -1 && (countAtEnd - countAtStart < 0L || countAtEnd == 0L)) {
                        countAtStart = 0L;
                    }
                    if ((currentCount = countAtEnd - countAtStart) < 0L) {
                        Activator.getDefault().logWarning(String.format("Negative count: start %d, end %d", countAtStart, countAtEnd));
                        currentCount = 0L;
                    } else if (currentCount > endTime - startTime) {
                        Activator.getDefault().logWarning(String.format("CPU Usage: Spent more time on CPU than allowed: %s spent %d when max should be %d", curTidName, currentCount, endTime - startTime));
                        currentCount = 0L;
                    }
                    cpuTotal += currentCount;
                    map.put(String.valueOf(curCpuName) + SPLIT_STRING + curTidName, currentCount);
                    LttngKernelCpuUsageAnalysis.addToMap(totalMap, curTidName, currentCount);
                    totalTime += currentCount;
                }
                map.put(curCpuName, cpuTotal);
            }
            for (Map.Entry entry : totalMap.entrySet()) {
                map.put("total/" + (String)entry.getKey(), (Long)entry.getValue());
            }
            map.put(TOTAL, totalTime);
        }
        catch (AttributeNotFoundException | TimeRangeException cpusNode) {
        }
        catch (StateSystemDisposedException | StateValueTypeException e) {
            Activator.getDefault().logError("Error getting CPU usage in a time range", e);
        }
        return map;
    }

    private static long interpolateCount(long count, long ts, long runningEnd, long runningTime) {
        long newCount = count;
        if (runningTime > 0L) {
            long runningStart = runningEnd - runningTime;
            if (ts < runningStart) {
                return newCount;
            }
            newCount += ts - runningStart;
        }
        return newCount;
    }

    private static void addToMap(Map<String, Long> map, String key, Long value) {
        Long addTo = map.get(key);
        if (addTo == null) {
            map.put(key, value);
        } else {
            map.put(key, addTo + value);
        }
    }
}

