/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.event.matching;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.matching.ITmfNetworkMatchDefinition;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfNetworkEventMatching;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfEventTypeCollectionHelper;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public class TcpEventMatching
implements ITmfNetworkMatchDefinition {
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"inet_sock_local_in", (Object)"inet_sock_local_out");

    private static boolean canMatchPacket(ITmfEvent event) {
        ITmfEventField content = event.getContent();
        return content.getField("seq") != null && content.getField("ack_seq") != null && content.getField("flags") != null;
    }

    public TmfNetworkEventMatching.Direction getDirection(ITmfEvent event) {
        String evname = event.getType().getName();
        if (!TcpEventMatching.canMatchPacket(event)) {
            return null;
        }
        if (evname.equals("inet_sock_local_in")) {
            return TmfNetworkEventMatching.Direction.IN;
        }
        if (evname.equals("inet_sock_local_out")) {
            return TmfNetworkEventMatching.Direction.OUT;
        }
        return null;
    }

    public List<Object> getUniqueField(ITmfEvent event) {
        ArrayList<Object> keys = new ArrayList<Object>();
        keys.add(event.getContent().getField("seq").getValue());
        keys.add(event.getContent().getField("ack_seq").getValue());
        keys.add(event.getContent().getField("flags").getValue());
        return keys;
    }

    public boolean canMatchTrace(ITmfTrace trace) {
        if (!(trace instanceof CtfTmfTrace)) {
            return false;
        }
        CtfTmfTrace ktrace = (CtfTmfTrace)trace;
        Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)ktrace.getContainedEventTypes());
        traceEvents.retainAll((Collection<?>)REQUIRED_EVENTS);
        return !traceEvents.isEmpty();
    }

    public TmfEventMatching.MatchingType[] getApplicableMatchingTypes() {
        TmfEventMatching.MatchingType[] types = new TmfEventMatching.MatchingType[]{TmfEventMatching.MatchingType.NETWORK};
        return types;
    }
}

