/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.event.matching;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.matching.ITmfNetworkMatchDefinition;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.linuxtools.tmf.core.event.matching.TmfNetworkEventMatching;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfEventTypeCollectionHelper;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public class TcpLttngEventMatching
implements ITmfNetworkMatchDefinition {
    private static final String[] key_seq = new String[]{"transport_fields", "thtype_tcp", "seq"};
    private static final String[] key_ackseq = new String[]{"transport_fields", "thtype_tcp", "ack_seq"};
    private static final String[] key_flags = new String[]{"transport_fields", "thtype_tcp", "flags"};
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"net_dev_queue", (Object)"netif_receive_skb");

    private static boolean canMatchPacket(ITmfEvent event) {
        TmfEventField field = (TmfEventField)event.getContent();
        String[] tcp_data = new String[]{"transport_fields", "thtype_tcp"};
        ITmfEventField data = field.getSubField(tcp_data);
        if (data != null) {
            return data.getValue() != null;
        }
        return false;
    }

    public List<Object> getUniqueField(ITmfEvent event) {
        ArrayList<Object> keys = new ArrayList<Object>();
        TmfEventField field = (TmfEventField)event.getContent();
        ITmfEventField data = field.getSubField(key_seq);
        if (data != null) {
            keys.add(data.getValue());
        }
        if ((data = field.getSubField(key_ackseq)) != null) {
            keys.add(data.getValue());
        }
        if ((data = field.getSubField(key_flags)) != null) {
            keys.add(data.getValue());
        }
        return keys;
    }

    public boolean canMatchTrace(ITmfTrace trace) {
        if (!(trace instanceof CtfTmfTrace)) {
            return false;
        }
        CtfTmfTrace ktrace = (CtfTmfTrace)trace;
        Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)ktrace.getContainedEventTypes());
        traceEvents.retainAll((Collection<?>)REQUIRED_EVENTS);
        return !traceEvents.isEmpty();
    }

    public TmfNetworkEventMatching.Direction getDirection(ITmfEvent event) {
        String evname = event.getType().getName();
        if (evname.equals("netif_receive_skb") && TcpLttngEventMatching.canMatchPacket(event)) {
            return TmfNetworkEventMatching.Direction.IN;
        }
        if (evname.equals("net_dev_queue") && TcpLttngEventMatching.canMatchPacket(event)) {
            return TmfNetworkEventMatching.Direction.OUT;
        }
        return null;
    }

    public TmfEventMatching.MatchingType[] getApplicableMatchingTypes() {
        TmfEventMatching.MatchingType[] types = new TmfEventMatching.MatchingType[]{TmfEventMatching.MatchingType.NETWORK};
        return types;
    }
}

