/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.trace;

import java.nio.BufferOverflowException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.Messages;
import org.eclipse.linuxtools.tmf.core.trace.TraceValidationStatus;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTrace;

public class LttngKernelTrace
extends CtfTmfTrace {
    private static final int CONFIDENCE = 100;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus validate(IProject project, String path) {
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try {
                TraceValidationStatus traceValidationStatus;
                CTFTrace temp = new CTFTrace(path);
                try {
                    String dom = (String)temp.getEnvironment().get("domain");
                    if (dom != null && dom.equals("\"kernel\"")) {
                        traceValidationStatus = new TraceValidationStatus(100, "org.eclipse.linuxtools.lttng2.core");
                        return traceValidationStatus;
                    }
                    return new Status(4, "org.eclipse.linuxtools.lttng2.core", Messages.LttngKernelTrace_DomainError);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (temp == null) return traceValidationStatus;
                    temp.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (CTFReaderException e) {
            return new Status(4, "org.eclipse.linuxtools.lttng2.core", e.toString(), (Throwable)e);
        }
        catch (NullPointerException e) {
            return new Status(4, "org.eclipse.linuxtools.lttng2.core", e.toString(), (Throwable)e);
        }
        catch (BufferOverflowException e) {
            return new Status(4, "org.eclipse.linuxtools.lttng2.core", String.valueOf(Messages.LttngKernelTrace_TraceReadError) + ": " + Messages.LttngKernelTrace_MalformedTrace);
        }
    }
}

