/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.linuxtools.lttng2.kernel.core.analysis.LttngKernelAnalysisModule;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ControlFlowPresentationProvider
extends TimeGraphPresentationProvider {
    public ControlFlowPresentationProvider() {
        super(Messages.ControlFlowView_stateTypeName);
    }

    private static State[] getStateValues() {
        return State.values();
    }

    public StateItem[] getStateTable() {
        State[] states = ControlFlowPresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            int status = ((TimeEvent)event).getValue();
            return ControlFlowPresentationProvider.getMatchingState(status).ordinal();
        }
        return -2;
    }

    public String getEventName(ITimeEvent event) {
        TimeEvent ev;
        if (event instanceof TimeEvent && (ev = (TimeEvent)event).hasValue()) {
            return ControlFlowPresentationProvider.getMatchingState(ev.getValue()).toString();
        }
        return Messages.ControlFlowView_multipleStates;
    }

    private static State getMatchingState(int status) {
        switch (status) {
            case 1: {
                return State.WAIT_BLOCKED;
            }
            case 5: {
                return State.WAIT_FOR_CPU;
            }
            case 2: {
                return State.USERMODE;
            }
            case 3: {
                return State.SYSCALL;
            }
            case 4: {
                return State.INTERRUPTED;
            }
        }
        return State.UNKNOWN;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (!(event instanceof TimeEvent && ((TimeEvent)event).hasValue() && event.getEntry() instanceof ControlFlowEntry)) {
            return retMap;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)entry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return retMap;
        }
        ITmfStateSystem ssq = module.getStateSystem();
        if (ssq == null) {
            return retMap;
        }
        int tid = entry.getThreadId();
        try {
            int cpusQuark = ssq.getQuarkAbsolute(new String[]{"CPUs"});
            List cpuQuarks = ssq.getSubAttributes(cpusQuark, false);
            for (Integer cpuQuark : cpuQuarks) {
                ITmfStateValue state;
                int currentThreadId;
                int currentThreadQuark = ssq.getQuarkRelative(cpuQuark.intValue(), new String[]{"Current_thread"});
                ITmfStateInterval interval = ssq.querySingleState(event.getTime(), currentThreadQuark);
                if (interval.getStateValue().isNull() || tid != (currentThreadId = (state = interval.getStateValue()).unboxInt())) continue;
                retMap.put(Messages.ControlFlowView_attributeCpuName, ssq.getAttributeName(cpuQuark.intValue()));
                break;
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException e) {
            // empty catch block
        }
        int status = ((TimeEvent)event).getValue();
        if (status == 3) {
            try {
                int syscallQuark = ssq.getQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
                ITmfStateInterval value = ssq.querySingleState(event.getTime(), syscallQuark);
                if (!value.getStateValue().isNull()) {
                    ITmfStateValue state = value.getStateValue();
                    retMap.put(Messages.ControlFlowView_attributeSyscallName, state.toString());
                }
            }
            catch (AttributeNotFoundException | TimeRangeException e) {
                Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (bounds.width <= gc.getFontMetrics().getAverageCharWidth()) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)entry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return;
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return;
        }
        int status = ((TimeEvent)event).getValue();
        if (status != 3) {
            return;
        }
        try {
            int syscallQuark = ss.getQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
            ITmfStateInterval value = ss.querySingleState(event.getTime(), syscallQuark);
            if (!value.getStateValue().isNull()) {
                ITmfStateValue state = value.getStateValue();
                gc.setForeground(gc.getDevice().getSystemColor(1));
                Utils.drawText((GC)gc, (String)state.toString().substring(4), (int)bounds.x, (int)(bounds.y - 2), (int)bounds.width, (boolean)true, (boolean)true);
            }
        }
        catch (AttributeNotFoundException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ControlFlowPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    private static enum State {
        UNKNOWN(new RGB(100, 100, 100)),
        WAIT_BLOCKED(new RGB(200, 200, 0)),
        WAIT_FOR_CPU(new RGB(200, 100, 0)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        INTERRUPTED(new RGB(200, 0, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

