/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowPresentationProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.analysis.LttngKernelAnalysisModule;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeLinkEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;

public class ControlFlowView
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.ui.views.controlflow";
    private static final String PROCESS_COLUMN = Messages.ControlFlowView_processColumn;
    private static final String TID_COLUMN = Messages.ControlFlowView_tidColumn;
    private static final String PTID_COLUMN = Messages.ControlFlowView_ptidColumn;
    private static final String BIRTH_TIME_COLUMN = Messages.ControlFlowView_birthTimeColumn;
    private static final String TRACE_COLUMN = Messages.ControlFlowView_traceColumn;
    private static final String[] COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN, PTID_COLUMN, BIRTH_TIME_COLUMN, TRACE_COLUMN};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{PROCESS_COLUMN, TID_COLUMN};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ControlFlowView() {
        super(ID, (TimeGraphPresentationProvider)new ControlFlowPresentationProvider());
        this.setTreeColumns(COLUMN_NAMES);
        this.setTreeLabelProvider(new ControlFlowTreeLabelProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ControlFlowFilterLabelProvider());
        this.setEntryComparator(new ControlFlowEntryComparator());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        Action hideArrowsAction = this.getTimeGraphCombo().getTimeGraphViewer().getHideArrowsAction(section);
        manager.add((IAction)hideArrowsAction);
        Action followArrowBwdAction = this.getTimeGraphCombo().getTimeGraphViewer().getFollowArrowBwdAction();
        followArrowBwdAction.setText(Messages.ControlFlowView_followCPUBwdText);
        followArrowBwdAction.setToolTipText(Messages.ControlFlowView_followCPUBwdText);
        manager.add((IAction)followArrowBwdAction);
        Action followArrowFwdAction = this.getTimeGraphCombo().getTimeGraphViewer().getFollowArrowFwdAction();
        followArrowFwdAction.setText(Messages.ControlFlowView_followCPUFwdText);
        followArrowFwdAction.setToolTipText(Messages.ControlFlowView_followCPUFwdText);
        manager.add((IAction)followArrowFwdAction);
    }

    protected String getNextText() {
        return Messages.ControlFlowView_nextProcessActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ControlFlowView_nextProcessActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ControlFlowView_previousProcessActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ControlFlowView_previousProcessActionToolTipText;
    }

    protected void buildEventList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)trace.getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return;
        }
        module.schedule();
        module.waitForInitialization();
        ITmfStateSystem ssq = module.getStateSystem();
        if (ssq == null) {
            return;
        }
        ArrayList<ControlFlowEntry> entryList = new ArrayList<ControlFlowEntry>();
        HashMap<Integer, ControlFlowEntry> entryMap = new HashMap<Integer, ControlFlowEntry>();
        long start = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), start));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            this.setEndTime(Math.max(this.getEndTime(), end + 1L));
            List threadQuarks = ssq.getQuarks(new String[]{"Threads", "*"});
            Iterator iterator = threadQuarks.iterator();
            block9: while (iterator.hasNext()) {
                List execNameIntervals;
                int threadQuark = (Integer)iterator.next();
                if (monitor.isCanceled()) {
                    return;
                }
                String threadName = ssq.getAttributeName(threadQuark);
                int threadId = -1;
                try {
                    threadId = Integer.parseInt(threadName);
                }
                catch (NumberFormatException e1) {
                    continue;
                }
                if (threadId <= 0) continue;
                try {
                    int execNameQuark = ssq.getQuarkRelative(threadQuark, new String[]{"Exec_name"});
                    execNameIntervals = ssq.queryHistoryRange(execNameQuark, start, end);
                }
                catch (AttributeNotFoundException e) {
                    continue;
                }
                catch (StateSystemDisposedException e) {
                    break;
                }
                for (ITmfStateInterval execNameInterval : execNameIntervals) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ControlFlowEntry entry = (ControlFlowEntry)((Object)entryMap.get(threadId));
                    if (!execNameInterval.getStateValue().isNull() && execNameInterval.getStateValue().getType() == ITmfStateValue.Type.STRING) {
                        String execName = execNameInterval.getStateValue().unboxStr();
                        long startTime = execNameInterval.getStartTime();
                        long endTime = execNameInterval.getEndTime() + 1L;
                        if (entry == null) {
                            ITmfStateInterval ppidInterval = null;
                            try {
                                int ppidQuark = ssq.getQuarkRelative(threadQuark, new String[]{"PPID"});
                                ppidInterval = ssq.querySingleState(startTime, ppidQuark);
                            }
                            catch (AttributeNotFoundException ppidQuark) {
                            }
                            catch (StateSystemDisposedException e) {
                                continue block9;
                            }
                            int ppid = -1;
                            if (ppidInterval != null && !ppidInterval.getStateValue().isNull()) {
                                ppid = ppidInterval.getStateValue().unboxInt();
                            }
                            entry = new ControlFlowEntry(threadQuark, trace, execName, threadId, ppid, startTime, endTime);
                            entryList.add(entry);
                            entryMap.put(threadId, entry);
                            continue;
                        }
                        entry.setName(execName);
                        entry.updateEndTime(endTime);
                        continue;
                    }
                    entryMap.remove(threadId);
                }
            }
            this.updateTree(entryList, parentTrace);
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            for (ControlFlowEntry entry : entryList) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.buildStatusEvents(entry.getTrace(), entry, monitor, start, end);
            }
            start = end;
        }
    }

    private void updateTree(List<ControlFlowEntry> entryList, ITmfTrace parentTrace) {
        ArrayList<ControlFlowEntry> rootListToAdd = new ArrayList<ControlFlowEntry>();
        ArrayList<ControlFlowEntry> rootListToRemove = new ArrayList<ControlFlowEntry>();
        List rootList = this.getEntryList(parentTrace);
        for (ControlFlowEntry entry : entryList) {
            boolean root;
            boolean bl = root = entry.getParent() == null;
            if (root && entry.getParentThreadId() > 0) {
                for (ControlFlowEntry parent : entryList) {
                    if (parent.getThreadId() != entry.getParentThreadId() || entry.getStartTime() < parent.getStartTime() || entry.getStartTime() > parent.getEndTime()) continue;
                    parent.addChild(entry);
                    root = false;
                    if (rootList == null || !rootList.contains((Object)entry)) break;
                    rootListToRemove.add(entry);
                    break;
                }
            }
            if (!root || rootList != null && rootList.contains((Object)entry)) continue;
            rootListToAdd.add(entry);
        }
        this.addToEntryList(parentTrace, rootListToAdd);
        this.removeFromEntryList(parentTrace, rootListToRemove);
    }

    private void buildStatusEvents(ITmfTrace trace, ControlFlowEntry entry, IProgressMonitor monitor, long start, long end) {
        if (start < entry.getEndTime() && end > entry.getStartTime()) {
            long resolution;
            long endTime;
            LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)entry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
            if (module == null) {
                return;
            }
            ITmfStateSystem ssq = module.getStateSystem();
            if (ssq == null) {
                return;
            }
            long startTime = Math.max(start, entry.getStartTime());
            List<ITimeEvent> eventList = this.getEventList(entry, startTime, endTime = Math.min(end + 1L, entry.getEndTime()), resolution = Math.max(1L, (end - ssq.getStartTime()) / (long)this.getDisplayWidth()), monitor);
            if (eventList == null) {
                return;
            }
            for (ITimeEvent event : eventList) {
                entry.addEvent(event);
            }
            if (trace.equals(this.getTrace())) {
                this.redraw();
            }
        }
        for (ITimeGraphEntry child : entry.getChildren()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.buildStatusEvents(trace, (ControlFlowEntry)child, monitor, start, end);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected List<ITimeEvent> getEventList(TimeGraphEntry tgentry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ArrayList<TimeEvent> eventList = null;
        if (!(tgentry instanceof ControlFlowEntry)) {
            return eventList;
        }
        ControlFlowEntry entry = (ControlFlowEntry)tgentry;
        long realStart = Math.max(startTime, entry.getStartTime());
        long realEnd = Math.min(endTime, entry.getEndTime());
        if (realEnd <= realStart) {
            return null;
        }
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)entry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return null;
        }
        ITmfStateSystem ssq = module.getStateSystem();
        if (ssq == null) {
            return null;
        }
        try {
            int statusQuark = ssq.getQuarkRelative(entry.getThreadQuark(), new String[]{"Status"});
            List statusIntervals = ssq.queryHistoryRange(statusQuark, realStart, realEnd - 1L, resolution, monitor);
            eventList = new ArrayList<TimeEvent>(statusIntervals.size());
            long lastEndTime = -1L;
            Iterator iterator = statusIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                int status = -1;
                try {
                    status = statusInterval.getStateValue().unboxInt();
                }
                catch (StateValueTypeException e) {
                    e.printStackTrace();
                }
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                }
                eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException | TimeRangeException e) {
            e.printStackTrace();
            return eventList;
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }

    private int getSelectionValue(long time) {
        int thread = -1;
        ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace());
        if (traces == null) {
            return thread;
        }
        ITmfTrace[] iTmfTraceArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfStateSystem ssq;
            ITmfTrace trace = iTmfTraceArray[n2];
            if (thread > 0) break;
            LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)trace.getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
            if (module != null && (ssq = module.getStateSystem()) != null && time >= ssq.getStartTime() && time <= ssq.getCurrentEndTime()) {
                List currentThreadQuarks = ssq.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
                Iterator iterator = currentThreadQuarks.iterator();
                while (iterator.hasNext()) {
                    int currentThreadQuark = (Integer)iterator.next();
                    try {
                        int statusQuark;
                        ITmfStateInterval statusInterval;
                        ITmfStateInterval currentThreadInterval = ssq.querySingleState(time, currentThreadQuark);
                        int currentThread = currentThreadInterval.getStateValue().unboxInt();
                        if (currentThread <= 0 || (statusInterval = ssq.querySingleState(time, statusQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThread), "Status"}))).getStartTime() != time) continue;
                        thread = currentThread;
                        break;
                    }
                    catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateSystemDisposedException stateSystemDisposedException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        return thread;
    }

    protected void synchingToTime(long time) {
        int selected = this.getSelectionValue(time);
        if (selected > 0) {
            ITimeGraphEntry[] iTimeGraphEntryArray = this.getTimeGraphViewer().getExpandedElements();
            int n = iTimeGraphEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ControlFlowEntry entry;
                ITimeGraphEntry element = iTimeGraphEntryArray[n2];
                if (element instanceof ControlFlowEntry && (entry = (ControlFlowEntry)element).getThreadId() == selected) {
                    this.getTimeGraphCombo().setSelection((ITimeGraphEntry)entry);
                    break;
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ArrayList<ILinkEvent> list = new ArrayList<ILinkEvent>();
        ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace());
        List entryList = this.getEntryList(this.getTrace());
        if (traces == null || entryList == null) {
            return list;
        }
        ITmfTrace[] iTmfTraceArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfStateSystem ssq;
            ITmfTrace trace = iTmfTraceArray[n2];
            LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)trace.getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
            if (module != null && (ssq = module.getStateSystem()) != null) {
                try {
                    long start = Math.max(startTime, ssq.getStartTime());
                    long end = Math.min(endTime, ssq.getCurrentEndTime());
                    if (end >= start) {
                        List currentThreadQuarks = ssq.getQuarks(new String[]{"CPUs", "*", "Current_thread"});
                        Iterator iterator = currentThreadQuarks.iterator();
                        while (iterator.hasNext()) {
                            int currentThreadQuark = (Integer)iterator.next();
                            long qstart = Math.max(ssq.querySingleState(start, currentThreadQuark).getStartTime() - 1L, ssq.getStartTime());
                            long qend = Math.min(ssq.querySingleState(end, currentThreadQuark).getEndTime() + 1L, ssq.getCurrentEndTime());
                            List currentThreadIntervals = ssq.queryHistoryRange(currentThreadQuark, qstart, qend, resolution, monitor);
                            int prevThread = 0;
                            long prevEnd = 0L;
                            long lastEnd = 0L;
                            for (ITmfStateInterval currentThreadInterval : currentThreadIntervals) {
                                int thread;
                                if (monitor.isCanceled()) {
                                    return null;
                                }
                                long time = currentThreadInterval.getStartTime();
                                if (time != lastEnd) {
                                    prevThread = 0;
                                    prevEnd = 0L;
                                }
                                if ((thread = currentThreadInterval.getStateValue().unboxInt()) > 0 && prevThread > 0) {
                                    ControlFlowEntry prevEntry = this.findEntry(entryList, trace, prevThread);
                                    ControlFlowEntry nextEntry = this.findEntry(entryList, trace, thread);
                                    list.add((ILinkEvent)new TimeLinkEvent((ITimeGraphEntry)prevEntry, (ITimeGraphEntry)nextEntry, prevEnd, time - prevEnd, 0));
                                }
                                lastEnd = currentThreadInterval.getEndTime() + 1L;
                                if (thread == 0) continue;
                                prevThread = thread;
                                prevEnd = lastEnd;
                            }
                        }
                    }
                }
                catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                    e.printStackTrace();
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return list;
    }

    private ControlFlowEntry findEntry(List<TimeGraphEntry> entryList, ITmfTrace trace, int threadId) {
        for (TimeGraphEntry entry : entryList) {
            if (!(entry instanceof ControlFlowEntry)) continue;
            ControlFlowEntry controlFlowEntry = (ControlFlowEntry)entry;
            if (controlFlowEntry.getThreadId() == threadId && controlFlowEntry.getTrace() == trace) {
                return controlFlowEntry;
            }
            if (!entry.hasChildren() || (controlFlowEntry = this.findEntry(entry.getChildren(), trace, threadId)) == null) continue;
            return controlFlowEntry;
        }
        return null;
    }

    private static class ControlFlowEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ControlFlowEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int result = 0;
            if (o1 instanceof ControlFlowEntry && o2 instanceof ControlFlowEntry) {
                ControlFlowEntry entry1 = (ControlFlowEntry)o1;
                ControlFlowEntry entry2 = (ControlFlowEntry)o2;
                result = entry1.getTrace().getStartTime().compareTo(entry2.getTrace().getStartTime());
                if (result == 0) {
                    result = entry1.getTrace().getName().compareTo(entry2.getTrace().getName());
                }
                if (result == 0) {
                    int n = entry1.getThreadId() < entry2.getThreadId() ? -1 : (result = entry1.getThreadId() > entry2.getThreadId() ? 1 : 0);
                }
            }
            if (result == 0) {
                result = o1.getStartTime() < o2.getStartTime() ? -1 : (o1.getStartTime() > o2.getStartTime() ? 1 : 0);
            }
            return result;
        }
    }

    private static class ControlFlowFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ControlFlowFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (columnIndex == 0) {
                return entry.getName();
            }
            if (columnIndex == 1) {
                return Integer.toString(entry.getThreadId());
            }
            return "";
        }
    }

    protected static class ControlFlowTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        protected ControlFlowTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ControlFlowEntry entry = (ControlFlowEntry)((Object)element);
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_processColumn)) {
                return entry.getName();
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_tidColumn)) {
                return Integer.toString(entry.getThreadId());
            }
            if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_ptidColumn)) {
                if (entry.getParentThreadId() > 0) {
                    return Integer.toString(entry.getParentThreadId());
                }
            } else {
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_birthTimeColumn)) {
                    return Utils.formatTime((long)entry.getStartTime(), (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC);
                }
                if (COLUMN_NAMES[columnIndex].equals(Messages.ControlFlowView_traceColumn)) {
                    return entry.getTrace().getName();
                }
            }
            return "";
        }
    }
}

