/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage.Messages;
import org.eclipse.linuxtools.lttng2.kernel.core.cpuusage.LttngKernelCpuUsageAnalysis;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.linuxtools.tmf.ui.viewers.tree.TmfTreeViewerEntry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class CpuUsageComposite
extends AbstractTmfTreeViewer {
    private LttngKernelCpuUsageAnalysis fModule = null;
    private static final String[] COLUMN_NAMES = new String[]{Messages.CpuUsageComposite_ColumnTID, Messages.CpuUsageComposite_ColumnProcess, Messages.CpuUsageComposite_ColumnPercent, Messages.CpuUsageComposite_ColumnTime};
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();

    public CpuUsageComposite(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new CpuLabelProvider());
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<TmfTreeColumnData> getColumnData() {
                ArrayList<TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(COLUMN_NAMES[0]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getTid().compareTo(n2.getTid());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[1]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getProcessName().compareTo(n2.getProcessName());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[2]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getPercent().compareTo(n2.getPercent());
                    }
                });
                column.setPercentageProvider(new TmfTreeColumnData.ITmfColumnPercentageProvider(){

                    public double getPercentage(Object data) {
                        CpuUsageEntry parent = (CpuUsageEntry)((Object)data);
                        return parent.getPercent() / 100.0;
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[3]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getTime().compareTo(n2.getTime());
                    }
                });
                columns.add(column);
                return columns;
            }
        };
    }

    public void initializeDataSource() {
        this.fModule = (LttngKernelCpuUsageAnalysis)this.getTrace().getAnalysisModuleOfClass(LttngKernelCpuUsageAnalysis.class, "org.eclipse.linuxtools.lttng2.kernel.core.cpuusage");
        if (this.fModule == null) {
            return;
        }
        this.fModule.schedule();
        this.fModule.waitForInitialization();
        this.fProcessNameMap.clear();
    }

    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        if (isSelection || start == end) {
            return null;
        }
        if (this.getTrace() == null || this.fModule == null) {
            return null;
        }
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return null;
        }
        Map cpuUsageMap = this.fModule.getCpuUsageInRange(Math.max(start, this.getStartTime()), Math.min(end, this.getEndTime()));
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        List entryList = root.getChildren();
        for (Map.Entry entry : cpuUsageMap.entrySet()) {
            String[] strings;
            if ((Long)entry.getValue() == 0L || !((String)entry.getKey()).startsWith("total") || (strings = ((String)entry.getKey()).split("/", 2)).length <= 1 || strings[1].equals("0")) continue;
            CpuUsageEntry obj = new CpuUsageEntry(strings[1], this.getProcessName(strings[1]), (double)((Long)entry.getValue()).longValue() / (double)(end - start) * 100.0, (Long)entry.getValue());
            entryList.add(obj);
        }
        return root;
    }

    private String getProcessName(String tid) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        TmfStateSystemAnalysisModule module = (TmfStateSystemAnalysisModule)this.getTrace().getAnalysisModuleOfClass(TmfStateSystemAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return tid;
        }
        ITmfStateSystem kernelSs = module.getStateSystem();
        if (kernelSs == null) {
            return tid;
        }
        try {
            int cpusNode = kernelSs.getQuarkAbsolute(new String[]{"Threads"});
            List cpuNodes = kernelSs.getSubAttributes(cpusNode, false);
            for (Integer tidQuark : cpuNodes) {
                List execNameIntervals;
                if (!kernelSs.getAttributeName(tidQuark.intValue()).equals(tid)) continue;
                try {
                    int execNameQuark = kernelSs.getQuarkRelative(tidQuark.intValue(), new String[]{"Exec_name"});
                    execNameIntervals = kernelSs.queryHistoryRange(execNameQuark, this.getStartTime(), this.getEndTime());
                }
                catch (AttributeNotFoundException e) {
                    continue;
                }
                catch (StateSystemDisposedException e) {
                    break;
                }
                for (ITmfStateInterval execNameInterval : execNameIntervals) {
                    if (execNameInterval.getStateValue().isNull() || execNameInterval.getStateValue().getType() != ITmfStateValue.Type.STRING) continue;
                    execName = execNameInterval.getStateValue().unboxStr();
                    this.fProcessNameMap.put(tid, execName);
                    return execName;
                }
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return tid;
    }

    protected static class CpuLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected CpuLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            CpuUsageEntry obj = (CpuUsageEntry)((Object)element);
            if (columnIndex == 0) {
                return obj.getTid();
            }
            if (columnIndex == 1) {
                return obj.getProcessName();
            }
            if (columnIndex == 2) {
                return String.format(Messages.CpuUsageComposite_TextPercent, obj.getPercent());
            }
            if (columnIndex == 3) {
                return NLS.bind((String)Messages.CpuUsageComposite_TextTime, (Object)obj.getTime());
            }
            return element.toString();
        }
    }
}

