/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage.CpuUsageComposite;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.cpuusage.Messages;
import org.eclipse.linuxtools.lttng2.kernel.core.cpuusage.LttngKernelCpuUsageAnalysis;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.eclipse.swt.widgets.Composite;

public class CpuUsageXYViewer
extends TmfCommonXLineChartViewer {
    private LttngKernelCpuUsageAnalysis fModule = null;
    private final Map<String, double[]> fYValues = new LinkedHashMap<String, double[]>();
    private static final double RESOLUTION = 0.4;
    private long fSelectedThread = -1L;

    public CpuUsageXYViewer(Composite parent, CpuUsageComposite treeViewer) {
        super(parent, Messages.CpuUsageXYViewer_Title, Messages.CpuUsageXYViewer_TimeXAxis, Messages.CpuUsageXYViewer_CpuYAxis);
        this.setResolution(0.4);
        treeViewer.addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof CpuUsageEntry) {
                    CpuUsageEntry entry = (CpuUsageEntry)((Object)selection);
                    CpuUsageXYViewer.this.setSelectedThread(Long.valueOf(entry.getTid()));
                }
            }
        });
    }

    protected void initializeDataSource() {
        if (this.getTrace() != null) {
            this.fModule = (LttngKernelCpuUsageAnalysis)this.getTrace().getAnalysisModuleOfClass(LttngKernelCpuUsageAnalysis.class, "org.eclipse.linuxtools.lttng2.kernel.core.cpuusage");
            if (this.fModule == null) {
                return;
            }
            this.fModule.schedule();
        }
    }

    private static double[] zeroFill(int nb) {
        double[] arr = new double[nb];
        Arrays.fill(arr, 0.0);
        return arr;
    }

    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        try {
            if (this.getTrace() == null || this.fModule == null) {
                return;
            }
            ITmfStateSystem ss = this.fModule.getStateSystem();
            if (ss == null) {
                return;
            }
            double[] xvalues = this.getXAxis(start, end, nb);
            if (xvalues.length == 0) {
                return;
            }
            this.setXAxis(xvalues);
            long traceStart = this.getStartTime();
            long traceEnd = this.getEndTime();
            long offset = this.getTimeOffset();
            long selectedThread = this.fSelectedThread;
            Map cpuUsageMap = this.fModule.getCpuUsageInRange(Math.max(start, traceStart), Math.min(end, traceEnd));
            HashMap<String, String> totalEntries = new HashMap<String, String>();
            this.fYValues.clear();
            this.fYValues.put(Messages.CpuUsageXYViewer_Total, CpuUsageXYViewer.zeroFill(xvalues.length));
            String stringSelectedThread = Long.toString(selectedThread);
            if (selectedThread != -1L) {
                this.fYValues.put(stringSelectedThread, CpuUsageXYViewer.zeroFill(xvalues.length));
            }
            for (Map.Entry entry : cpuUsageMap.entrySet()) {
                String[] strings;
                if ((Long)entry.getValue() == 0L || !((String)entry.getKey()).startsWith("total") || (strings = ((String)entry.getKey()).split("/", 2)).length <= 1 || strings[1].equals("0")) continue;
                totalEntries.put(strings[1], (String)entry.getKey());
            }
            double prevX = xvalues[0];
            long prevTime = (long)prevX + offset;
            prevTime = Math.max(traceStart, prevTime);
            prevTime = Math.min(traceEnd, prevTime);
            int i = 1;
            while (i < xvalues.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                long totalCpu = 0L;
                double x = xvalues[i];
                long time = (long)x + offset;
                time = Math.max(traceStart, time);
                time = Math.min(traceEnd, time);
                cpuUsageMap = this.fModule.getCpuUsageInRange(prevTime, time);
                for (Map.Entry entry : totalEntries.entrySet()) {
                    Long cpuEntry = (Long)cpuUsageMap.get(entry.getValue());
                    cpuEntry = cpuEntry != null ? cpuEntry : 0L;
                    totalCpu += cpuEntry.longValue();
                    if (!((String)entry.getKey()).equals(stringSelectedThread)) continue;
                    this.fYValues.get(entry.getKey())[i] = (double)cpuEntry.longValue() / (double)(time - prevTime) * 100.0;
                }
                this.fYValues.get((Object)Messages.CpuUsageXYViewer_Total)[i] = (double)totalCpu / (double)(time - prevTime) * 100.0;
                prevTime = time;
                ++i;
            }
            for (Map.Entry<String, double[]> entry : this.fYValues.entrySet()) {
                this.setSeries(entry.getKey(), entry.getValue());
            }
            if (monitor.isCanceled()) {
                return;
            }
            this.updateDisplay();
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error updating the data of the CPU usage view", e);
        }
    }

    public void setSelectedThread(long tid) {
        this.cancelUpdate();
        this.deleteSeries(Long.toString(this.fSelectedThread));
        this.fSelectedThread = tid;
        this.updateContent();
    }
}

