/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesEntry
extends TimeGraphEntry
implements Comparable<ITimeGraphEntry> {
    private final int fId;
    private final ITmfTrace fTrace;
    private final Type fType;
    private final int fQuark;

    public ResourcesEntry(int quark, ITmfTrace trace, String name, long startTime, long endTime, Type type, int id) {
        super(name, startTime, endTime);
        this.fId = id;
        this.fTrace = trace;
        this.fType = type;
        this.fQuark = quark;
    }

    public ResourcesEntry(ITmfTrace trace, String name, long startTime, long endTime, int id) {
        this(-1, trace, name, startTime, endTime, Type.NULL, id);
    }

    public ResourcesEntry(int quark, ITmfTrace trace, long startTime, long endTime, Type type, int id) {
        this(quark, trace, String.valueOf(type.toString()) + " " + id, startTime, endTime, type, id);
    }

    public int getId() {
        return this.fId;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public Type getType() {
        return this.fType;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public boolean hasTimeEvents() {
        return this.fType != Type.NULL;
    }

    public void addChild(TimeGraphEntry entry) {
        if (!(entry instanceof ResourcesEntry)) {
            throw new IllegalArgumentException();
        }
        ResourcesEntry rEntry = (ResourcesEntry)entry;
        int index = 0;
        while (index < this.getChildren().size()) {
            ResourcesEntry other = (ResourcesEntry)this.getChildren().get(index);
            if (rEntry.compareTo((ITimeGraphEntry)other) < 0) break;
            ++index;
        }
        rEntry.setParent(this);
        this.getChildren().add(index, rEntry);
    }

    @Override
    public int compareTo(ITimeGraphEntry other) {
        if (!(other instanceof ResourcesEntry)) {
            return -1;
        }
        ResourcesEntry o = (ResourcesEntry)other;
        int ret = this.getType().compareTo(o.getType());
        if (ret != 0) {
            return ret;
        }
        return Integer.compare(this.getId(), o.getId());
    }

    public static enum Type {
        NULL,
        CPU,
        IRQ,
        SOFT_IRQ;

    }
}

