/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.lttng2.kernel.core.analysis.LttngKernelAnalysisModule;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private long fLastThreadId = -1L;

    private static State[] getStateValues() {
        return State.values();
    }

    private static State getEventState(TimeEvent event) {
        if (event.hasValue()) {
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == ResourcesEntry.Type.CPU) {
                if (value == 0) {
                    return State.IDLE;
                }
                if (value == 1) {
                    return State.USERMODE;
                }
                if (value == 2) {
                    return State.SYSCALL;
                }
                if (value == 3) {
                    return State.IRQ;
                }
                if (value == 4) {
                    return State.SOFT_IRQ;
                }
            } else {
                if (entry.getType() == ResourcesEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE;
                }
                if (entry.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                    if (value == -2) {
                        return State.SOFT_IRQ_RAISED;
                    }
                    return State.SOFT_IRQ_ACTIVE;
                }
            }
        }
        return null;
    }

    public int getStateTableIndex(ITimeEvent event) {
        State state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        State[] states = ResourcesPresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public String getEventName(ITimeEvent event) {
        State state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.toString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            ResourcesEntry entry = (ResourcesEntry)event.getEntry();
            if (tcEvent.hasValue()) {
                LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)entry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
                if (module == null) {
                    return retMap;
                }
                ITmfStateSystem ss = module.getStateSystem();
                if (ss == null) {
                    return retMap;
                }
                if (entry.getType().equals((Object)ResourcesEntry.Type.IRQ) || entry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                    int cpu = tcEvent.getValue();
                    if (cpu >= 0) {
                        retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
                    }
                } else if (entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                    int status = tcEvent.getValue();
                    if (status == 3) {
                        int cpu = entry.getId();
                        try {
                            List fullState = ss.queryFullState(event.getTime());
                            List irqQuarks = ss.getQuarks(new String[]{"Resources", "IRQs", "*"});
                            Iterator iterator = irqQuarks.iterator();
                            while (iterator.hasNext()) {
                                int irqQuark = (Integer)iterator.next();
                                if (((ITmfStateInterval)fullState.get(irqQuark)).getStateValue().unboxInt() != cpu) continue;
                                ITmfStateInterval value = ss.querySingleState(event.getTime(), irqQuark);
                                if (!value.getStateValue().isNull()) {
                                    int irq = Integer.parseInt(ss.getAttributeName(irqQuark));
                                    retMap.put(Messages.ResourcesView_attributeIrqName, String.valueOf(irq));
                                }
                                break;
                            }
                        }
                        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException e) {}
                    } else if (status == 4) {
                        int cpu = entry.getId();
                        try {
                            List fullState = ss.queryFullState(event.getTime());
                            List softIrqQuarks = ss.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
                            Iterator iterator = softIrqQuarks.iterator();
                            while (iterator.hasNext()) {
                                int softIrqQuark = (Integer)iterator.next();
                                if (((ITmfStateInterval)fullState.get(softIrqQuark)).getStateValue().unboxInt() != cpu) continue;
                                ITmfStateInterval value = ss.querySingleState(event.getTime(), softIrqQuark);
                                if (!value.getStateValue().isNull()) {
                                    int softIrq = Integer.parseInt(ss.getAttributeName(softIrqQuark));
                                    retMap.put(Messages.ResourcesView_attributeSoftIrqName, String.valueOf(softIrq));
                                }
                                break;
                            }
                        }
                        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException e) {}
                    } else if (status == 1 || status == 2) {
                        try {
                            retMap.put(Messages.ResourcesView_attributeHoverTime, Utils.formatTime((long)hoverTime, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC));
                            int cpuQuark = entry.getQuark();
                            int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                            ITmfStateInterval interval = ss.querySingleState(hoverTime, currentThreadQuark);
                            if (!interval.getStateValue().isNull()) {
                                int syscallQuark;
                                ITmfStateValue value = interval.getStateValue();
                                int currentThreadId = value.unboxInt();
                                retMap.put(Messages.ResourcesView_attributeTidName, Integer.toString(currentThreadId));
                                int execNameQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "Exec_name"});
                                interval = ss.querySingleState(hoverTime, execNameQuark);
                                if (!interval.getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    retMap.put(Messages.ResourcesView_attributeProcessName, value.unboxStr());
                                }
                                if (status == 2 && !(interval = ss.querySingleState(hoverTime, syscallQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "System_call"}))).getStateValue().isNull()) {
                                    value = interval.getStateValue();
                                    retMap.put(Messages.ResourcesView_attributeSyscallName, value.unboxStr());
                                }
                            }
                        }
                        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
                        }
                        catch (StateSystemDisposedException stateSystemDisposedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        ITmfTimeGraphDrawingHelper drawingHelper = this.getDrawingHelper();
        if (bounds.width <= gc.getFontMetrics().getAverageCharWidth()) {
            return;
        }
        if (!(event instanceof TimeEvent)) {
            return;
        }
        TimeEvent tcEvent = (TimeEvent)event;
        if (!tcEvent.hasValue()) {
            return;
        }
        ResourcesEntry entry = (ResourcesEntry)event.getEntry();
        if (!entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
            return;
        }
        int status = tcEvent.getValue();
        if (status != 1 && status != 2) {
            return;
        }
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)entry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return;
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return;
        }
        long time = event.getTime();
        try {
            while (time < event.getTime() + event.getDuration()) {
                int x;
                int cpuQuark = entry.getQuark();
                int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                ITmfStateInterval tidInterval = ss.querySingleState(time, currentThreadQuark);
                if (!tidInterval.getStateValue().isNull()) {
                    int syscallQuark;
                    int width;
                    int x2;
                    long endTime;
                    long startTime;
                    ITmfStateInterval interval;
                    ITmfStateValue value = tidInterval.getStateValue();
                    int currentThreadId = value.unboxInt();
                    if (status == 1 && (long)currentThreadId != this.fLastThreadId) {
                        int execNameQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "Exec_name"});
                        interval = ss.querySingleState(time, execNameQuark);
                        if (!interval.getStateValue().isNull()) {
                            value = interval.getStateValue();
                            gc.setForeground(gc.getDevice().getSystemColor(1));
                            startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                            endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                            if (drawingHelper.getXForTime(endTime) > bounds.x) {
                                x2 = Math.max(drawingHelper.getXForTime(startTime), bounds.x);
                                width = Math.min(drawingHelper.getXForTime(endTime), bounds.x + bounds.width) - x2;
                                int drawn = Utils.drawText((GC)gc, (String)value.unboxStr(), (int)(x2 + 1), (int)(bounds.y - 2), (int)(width - 1), (boolean)true, (boolean)true);
                                if (drawn > 0) {
                                    this.fLastThreadId = currentThreadId;
                                }
                            }
                        }
                    } else if (status == 2 && !(interval = ss.querySingleState(time, syscallQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "System_call"}))).getStateValue().isNull()) {
                        value = interval.getStateValue();
                        gc.setForeground(gc.getDevice().getSystemColor(1));
                        startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                        endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                        if (drawingHelper.getXForTime(endTime) > bounds.x) {
                            x2 = Math.max(drawingHelper.getXForTime(startTime), bounds.x);
                            width = Math.min(drawingHelper.getXForTime(endTime), bounds.x + bounds.width) - x2;
                            Utils.drawText((GC)gc, (String)value.unboxStr().substring(4), (int)(x2 + 1), (int)(bounds.y - 2), (int)(width - 1), (boolean)true, (boolean)true);
                        }
                    }
                }
                if ((time = tidInterval.getEndTime() + 1L) >= event.getTime() + event.getDuration() || (x = drawingHelper.getXForTime(time)) < bounds.x) continue;
                gc.setForeground(gc.getDevice().getSystemColor(15));
                gc.drawLine(x, bounds.y + 1, x, bounds.y + bounds.height - 2);
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error in ResourcesPresentationProvider", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
        this.fLastThreadId = -1L;
    }

    private static enum State {
        IDLE(new RGB(200, 200, 200)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        IRQ(new RGB(200, 0, 100)),
        SOFT_IRQ(new RGB(200, 150, 100)),
        IRQ_ACTIVE(new RGB(200, 0, 100)),
        SOFT_IRQ_RAISED(new RGB(200, 200, 0)),
        SOFT_IRQ_ACTIVE(new RGB(200, 150, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

