/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.analysis.LttngKernelAnalysisModule;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystem;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.ui.views.resources";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    protected void buildEventList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        long startTime;
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)trace.getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return;
        }
        module.schedule();
        module.waitForInitialization();
        ITmfStateSystem ssq = module.getStateSystem();
        if (ssq == null) {
            return;
        }
        HashMap<Integer, ResourcesEntry> entryMap = new HashMap<Integer, ResourcesEntry>();
        ResourcesEntry traceEntry = null;
        long start = startTime = ssq.getStartTime();
        this.setStartTime(Math.min(this.getStartTime(), startTime));
        boolean complete = false;
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            long endTime = end + 1L;
            this.setEndTime(Math.max(this.getEndTime(), endTime));
            if (traceEntry == null) {
                traceEntry = new ResourcesEntry(trace, trace.getName(), startTime, endTime, 0);
                List<ResourcesEntry> entryList = Collections.singletonList(traceEntry);
                this.addToEntryList(parentTrace, entryList);
            } else {
                traceEntry.updateEndTime(endTime);
            }
            List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
            for (Integer cpuQuark : cpuQuarks) {
                int cpu = Integer.parseInt(ssq.getAttributeName(cpuQuark.intValue()));
                ResourcesEntry entry = (ResourcesEntry)entryMap.get(cpuQuark);
                if (entry == null) {
                    entry = new ResourcesEntry(cpuQuark, trace, startTime, endTime, ResourcesEntry.Type.CPU, cpu);
                    entryMap.put(cpuQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            List irqQuarks = ssq.getQuarks(new String[]{"Resources", "IRQs", "*"});
            for (Integer irqQuark : irqQuarks) {
                int irq = Integer.parseInt(ssq.getAttributeName(irqQuark.intValue()));
                ResourcesEntry entry = (ResourcesEntry)entryMap.get(irqQuark);
                if (entry == null) {
                    entry = new ResourcesEntry(irqQuark, trace, startTime, endTime, ResourcesEntry.Type.IRQ, irq);
                    entryMap.put(irqQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            List softIrqQuarks = ssq.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
            for (Integer softIrqQuark : softIrqQuarks) {
                int softIrq = Integer.parseInt(ssq.getAttributeName(softIrqQuark.intValue()));
                ResourcesEntry entry = (ResourcesEntry)entryMap.get(softIrqQuark);
                if (entry == null) {
                    entry = new ResourcesEntry(softIrqQuark, trace, startTime, endTime, ResourcesEntry.Type.SOFT_IRQ, softIrq);
                    entryMap.put(softIrqQuark, entry);
                    traceEntry.addChild(entry);
                    continue;
                }
                entry.updateEndTime(endTime);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            long resolution = Math.max(1L, (endTime - ssq.getStartTime()) / (long)this.getDisplayWidth());
            for (TimeGraphEntry entry : traceEntry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                List<ITimeEvent> eventList = this.getEventList(entry, start, endTime, resolution, monitor);
                if (eventList != null) {
                    for (ITimeEvent event : eventList) {
                        entry.addEvent(event);
                    }
                }
                this.redraw();
            }
            start = end;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ResourcesEntry resourcesEntry = (ResourcesEntry)entry;
        LttngKernelAnalysisModule module = (LttngKernelAnalysisModule)resourcesEntry.getTrace().getAnalysisModuleOfClass(LttngKernelAnalysisModule.class, "org.eclipse.linuxtools.lttng2.kernel.analysis");
        if (module == null) {
            return null;
        }
        ITmfStateSystem ssq = module.getStateSystem();
        if (ssq == null) {
            return null;
        }
        long realStart = Math.max(startTime, ssq.getStartTime());
        long realEnd = Math.min(endTime, ssq.getCurrentEndTime() + 1L);
        if (realEnd <= realStart) {
            return null;
        }
        ArrayList<Object> eventList = null;
        int quark = resourcesEntry.getQuark();
        try {
            if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                int statusQuark = ssq.getQuarkRelative(quark, new String[]{"Status"});
                List statusIntervals = ssq.queryHistoryRange(statusQuark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList(statusIntervals.size());
                long lastEndTime = -1L;
                for (ITmfStateInterval statusInterval : statusIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    int status = statusInterval.getStateValue().unboxInt();
                    long time = statusInterval.getStartTime();
                    long duration = statusInterval.getEndTime() - time + 1L;
                    if (!statusInterval.getStateValue().isNull()) {
                        if (lastEndTime != time && lastEndTime != -1L) {
                            eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                        }
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, status));
                    } else if (lastEndTime == -1L || time + duration >= endTime) {
                        eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                    }
                    lastEndTime = time + duration;
                }
            } else if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.IRQ)) {
                List irqIntervals = ssq.queryHistoryRange(quark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList<Object>(irqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval irqInterval : irqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = irqInterval.getStartTime();
                    long duration = irqInterval.getEndTime() - time + 1L;
                    if (!irqInterval.getStateValue().isNull()) {
                        int cpu = irqInterval.getStateValue().unboxInt();
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, cpu));
                        lastIsNull = false;
                    } else {
                        if (lastEndTime == -1L) {
                            eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                        } else {
                            if (lastEndTime != time && lastIsNull) {
                                eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime, -1));
                            }
                            if (time + duration >= endTime) {
                                eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                            }
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            } else if (resourcesEntry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                List softIrqIntervals = ssq.queryHistoryRange(quark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList(softIrqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval softIrqInterval : softIrqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = softIrqInterval.getStartTime();
                    long duration = softIrqInterval.getEndTime() - time + 1L;
                    if (!softIrqInterval.getStateValue().isNull()) {
                        int cpu = softIrqInterval.getStateValue().unboxInt();
                        eventList.add(new TimeEvent((ITimeGraphEntry)entry, time, duration, cpu));
                    } else {
                        if (lastEndTime == -1L) {
                            eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                        } else {
                            if (lastEndTime != time && lastIsNull) {
                                eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime, -1));
                            }
                            if (time + duration >= endTime) {
                                eventList.add(new NullTimeEvent((ITimeGraphEntry)entry, time, duration));
                            }
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }
}

