/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ust.core.trace.callstack;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.linuxtools.tmf.core.callstack.CallStackStateProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEvent;

public class LttngUstCallStackProvider
extends CallStackStateProvider {
    private static final String CONTEXT_VTID = "context._vtid";
    private static final String CONTEXT_PROCNAME = "context._procname";
    private static final String FIELD_ADDR = "addr";
    private static final Set<String> FUNC_ENTRY_EVENTS = new HashSet<String>();
    private static final Set<String> FUNC_EXIT_EVENTS = new HashSet<String>();
    private static final int VERSION = 1;

    static {
        FUNC_ENTRY_EVENTS.add("lttng_ust_cyg_profile:func_entry");
        FUNC_ENTRY_EVENTS.add("lttng_ust_cyg_profile_fast:func_entry");
        FUNC_EXIT_EVENTS.add("lttng_ust_cyg_profile:func_exit");
        FUNC_EXIT_EVENTS.add("lttng_ust_cyg_profile_fast:func_exit");
    }

    public LttngUstCallStackProvider(ITmfTrace trace) {
        super(trace);
    }

    public LttngUstCallStackProvider getNewInstance() {
        return new LttngUstCallStackProvider(this.getTrace());
    }

    public int getVersion() {
        return 1;
    }

    protected boolean considerEvent(ITmfEvent event) {
        if (!(event instanceof CtfTmfEvent)) {
            return false;
        }
        ITmfEventField content = ((CtfTmfEvent)event).getContent();
        return content.getField(CONTEXT_VTID) != null && content.getField(CONTEXT_PROCNAME) != null;
    }

    public String functionEntry(ITmfEvent event) {
        String eventName = event.getType().getName();
        if (!FUNC_ENTRY_EVENTS.contains(eventName)) {
            return null;
        }
        Long address = (Long)event.getContent().getField(FIELD_ADDR).getValue();
        return Long.toHexString(address);
    }

    public String functionExit(ITmfEvent event) {
        String eventName = event.getType().getName();
        if (!FUNC_EXIT_EVENTS.contains(eventName)) {
            return null;
        }
        ITmfEventField field = event.getContent().getField(FIELD_ADDR);
        if (field == null) {
            return "UNDEFINED";
        }
        Long address = (Long)field.getValue();
        return Long.toHexString(address);
    }

    public String getThreadName(ITmfEvent event) {
        ITmfEventField content = ((CtfTmfEvent)event).getContent();
        String procName = (String)content.getField(CONTEXT_PROCNAME).getValue();
        Long vtid = (Long)content.getField(CONTEXT_VTID).getValue();
        if (procName == null || vtid == null) {
            throw new IllegalStateException();
        }
        return new String(String.valueOf(procName) + '-' + vtid.toString());
    }
}

