/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableSet;
import org.eclipse.linuxtools.internal.lttng2.ust.core.memoryusage.MemoryUsageStateProvider;
import org.eclipse.linuxtools.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.linuxtools.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.linuxtools.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class UstMemoryAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.memory";
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"ust_libc:malloc", (Object)"ust_libc:free", (Object)"ust_libc:calloc", (Object)"ust_libc:realloc", (Object)"ust_libc:memalign", (Object)"ust_libc:posix_memalign", (Object[])new String[0]);
    private static final ImmutableSet<TmfAnalysisRequirement> REQUIREMENTS;

    static {
        TmfAnalysisRequirement eventsReq = new TmfAnalysisRequirement("event", REQUIRED_EVENTS, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        eventsReq.addInformation(Messages.UstMemoryAnalysisModule_EventsLoadingInformation);
        eventsReq.addInformation(Messages.UstMemoryAnalysisModule_EventsLoadingExampleInformation);
        TmfAnalysisRequirement domainReq = new TmfAnalysisRequirement("domain");
        domainReq.addValue("UST", TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        REQUIREMENTS = ImmutableSet.of((Object)domainReq, (Object)eventsReq);
    }

    protected ITmfStateProvider createStateProvider() {
        return new MemoryUsageStateProvider(this.getTrace());
    }

    public void setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!(trace instanceof LttngUstTrace)) {
            throw new IllegalStateException("UstMemoryAnalysisModule: trace should be of type LttngUstTrace");
        }
        super.setTrace(trace);
    }

    protected LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        return REQUIREMENTS;
    }
}

